<?php
/**
 * Created by PhpStorm.
 * User: ladan
 * Date: 9/26/2018
 * Time: 11:04
 */

namespace App\Traits;

use App\Http\Resources\License\LicenseResourceApi;
use App\Model\License as ModelLicense;
use Carbon\Carbon;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

trait License
{
    static function allLicense($query)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Authorization' => 'Bearer '.$access_token
        ];
        $client = new Client();
        $res = $client->get(config('global.base_api').'/license', [
            'query'=>$query,
            'headers' => $headers
        ]);
        $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        dd('shhsu');
        try {
            $res = $client->get(config('global.base_api').'/license', [
                'query'=>$query,
                'headers' => $headers
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
    static function myLicense(Request $request)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $user_token   = session()->get('user_token');
        $headers = [
            'Accept' => 'application/json',
            'Authorization' => 'Bearer '.$access_token
        ];
        $queryString = $request->getQueryString();
        $client = new Client();
        try {
            $res = $client->post(config('global.base_api').'/user/license?'.$queryString, [
                'headers' => $headers,
                'form_params' => ['access_token' => $user_token]
            ]);
            $response =  $res->getBody()->getContents();
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return Oauth::paginate(json_decode($response),$request);
    }
    static function licenseInfoAdmin($code)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Authorization' => 'Bearer '.$access_token
        ];
        $client = new Client();
        try {
            $res = $client->get(config('global.base_api').'/license/'.$code, [
                'headers' => $headers
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
    static function licenseInfoUser($code)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $user_token   = session()->get('user_token');
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Authorization' => 'Bearer '.$access_token
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.base_api').'/user/license/'.$code, [
                'headers' => $headers,
                'form_params' => ['access_token' => $user_token]
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
    static function updateLicenseAdmin($code , $domain , $private_balance , $halfprivate_balance , $public_balance , $sms_balance , $status , $expire_date)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Authorization' => 'Bearer '.$access_token
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.base_api').'/license/'.$code, [
                'headers' => $headers,
                'form_params' => [
                    'domain' => $domain,
                    'private_balance' => $private_balance,
                    'halfprivate_balance' => $halfprivate_balance,
                    'public_balance' => $public_balance,
                    'sms_balance' => $sms_balance,
                    'status' => $status,
                    'expire_date' => $expire_date,
                    '_method'=>'PUT'
                ]
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
    static function updateLicenseUser($code , $domain , $private_balance , $halfprivate_balance , $public_balance , $sms_balance , $status , $expire_date , $suffix)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $user_token   = session()->get('user_token');
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Authorization' => 'Bearer '.$access_token
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.base_api').'/license/'.$code, [
                'headers' => $headers,
                'form_params' => [
                    'domain' => $domain,
                    'suffix' => $suffix,
                    'private_balance' => $private_balance,
                    'halfprivate_balance' => $halfprivate_balance,
                    'public_balance' => $public_balance,
                    'sms_balance' => $sms_balance,
                    'status' => $status,
                    'expire_date' => $expire_date,
                    'access_token' => $user_token,
                    '_method' => 'PUT'
                ]
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
    static function create_host($mobile , $domain , $license , $lang , $lang_title , $template , $email , $password){
        $client = new Client();
        $token  = md5(config('global.create_api_secret').$mobile);
        try {
            $res = $client->post(config('global.create_api'), [
                'form_params' => [
                    'mobile'    => $mobile,
                    'token'     => $token,
                    'domain'    => $domain,
                    'license'   => $license,
                    'lang'      => $lang,
                    'lang_title'=> $lang_title,
                    'template'  => $template,
                    'email'     => $email,
                    'password'  => $password,
                ]
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
    static function checkLicense($code)
    {
        $license = ModelLicense::where('code', $code)->first();
        if (!$license){
            $response = response()->json(['error' => 'License with Code  ' . $code . 'Does not exist' , 'code' => 404 ]);
        }
        

        if ($license->expire_date < Carbon::now()) {
            $license->status = 0;
            $license->save();
        }

        $response = response()->json(['error' => null , 'code' => 200 , 'body' => ['data' => new LicenseResourceApi($license)]]);
        return $response;

    }
    static function consumeLicense($code , $private_balance , $halfprivate_balance , $public_balance , $sms_balance)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Authorization' => 'Bearer '.$access_token
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.base_api').'/license/'.$code.'/consume', [
                'headers' => $headers,
                'form_params' => [
                    'private_balance' => $private_balance,
                    'halfprivate_balance' => $halfprivate_balance,
                    'public_balance' => $public_balance,
                    'sms_balance' => $sms_balance,
                ]
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }

    static function get_information_course($course_key , $lang , $url)
    {
        $client = new Client();
        try {
            $res = $client->post($url.'api/get_description', [
                'form_params' => [
                    'code' => '7e54a8e8ad12851df53bae5e98aae3ed',
                    'course_key' => $course_key,
                    'lang' => $lang
                ]
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }

}