<?php
/**
 * Created by PhpStorm.
 * User: ladan
 * Date: 9/9/2018
 * Time: 11:43
 */

namespace App\Traits;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

trait Gateway
{
    static function zarinpal($Amount){
        $MerchantID = 'XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX'; //Required
        $Description = 'توضیحات تراکنش تستی'; // Required
        $Email = 'UserEmail@Mail.Com'; // Optional
        $Mobile = '09123456789'; // Optional
        $CallbackURL = route('verify_zarinpal'); // Required


        $client = new \SoapClient('https://sandbox.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);

        $result = $client->PaymentRequest(
        [
            'MerchantID' => $MerchantID,
            'Amount' => $Amount,
            'Description' => $Description,
            'Email' => $Email,
            'Mobile' => $Mobile,
            'CallbackURL' => $CallbackURL,
        ]
        );

        return $result;
        //Redirect to URL You can do it also by creating a form
        
    }
    static function getAccessToken($terminalID,$invoiceID,$amount, $calback)
    {
        $result = [];
        try {
            $guzzle = new Client();
            $response = $guzzle->post("https://mabna.shaparak.ir:8081/V1/PeymentApi/GetToken", [
                'form_params' => [
                    'Amount' => $amount,
                    'callbackURL' => $calback,
                    'invoiceID' => $invoiceID,
                    'terminalID' => $terminalID
                ],
            ]);
            $guzzleresult = json_decode((string)$response->getBody(), true);
            $result['status'] = $guzzleresult['Status'];
            $result['Accesstoken'] = $guzzleresult['Accesstoken'];
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $result['status'] = -1;
                $result['error'] = $e->getResponse()->getReasonPhrase();
            } else {
                $result['status'] = -1;
                $result['error'] = $e->getMessage();
            }
        }
        return $result;
    }

    static function verifyOrder($terminalID,$digitalReceipt)
    {
        $result = [];
        try {
            $guzzle = new Client();
            $response = $guzzle->post("https://mabna.shaparak.ir:8081/V1/PeymentApi/Advice", [
                'form_params' => [
                    'digitalreceipt' => $digitalReceipt,
                    'Tid' => $terminalID
                ],
            ]);
            $guzzleresult = json_decode((string)$response->getBody(), true);
            $result['status'] = $guzzleresult['Status'];
            $result['returnId'] = $guzzleresult['ReturnId'];
            $result['message'] = $guzzleresult['Message'];
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $result['status'] = 'NOK';
                $result['returnId'] = -1;
                $result['error'] = $e->getResponse()->getReasonPhrase();
            } else {
                $result['status'] = 'NOK';
                $result['returnId'] = -1;
                $result['error'] = $e->getMessage();
            }
        }
        return $result;
    }
}