<?php
/**
 * Created by PhpStorm.
 * User: ladan
 * Date: 9/3/2018
 * Time: 8:57
 */

namespace App\Traits;

use GuzzleHttp\Client;

trait Event
{
    use Oauth;
    static function listEvent($types , $user_id , $from , $to){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $URI = config('global.base_api').'/event?types='.$types.'&user_id='.$user_id.'&from='.$from.'&to='.$to;

        $client = new Client;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        try
        {
            $res = $client->get( $URI, $params );
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }

        return json_decode($response);
    }

    static function createEvent($event_json){

        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/event';
        $res = $client->post($URI ,
            [
                'headers' => [
                    'Accept' => "application/json",
                    'Content-Type' => "application/json",
                    'Authorization' => 'Bearer '.$access_token
                ],
                'body' => $event_json
            ]
        );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function EditEvent($event_json , $id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/event/'.$id;
        $res = $client->put( $URI ,
            [
                'headers' => [
                    'Accept' => "application/json",
                    'Content-Type' => "application/json",
                    'Authorization' => 'Bearer '.$access_token
                ],
                'body' => $event_json
            ]
        );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function DeleteEvent($user_id , $event_id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/event/'.$event_id;
        $res = $client->delete($URI ,
            [
                'headers' => [
                    'Accept' => "application/json",
                    'Content-Type' => "application/x-www-form-urlencoded",
                    'Authorization' => 'Bearer '.$access_token
                ],
                'form_params' => [
                    'user_id' => $user_id
                ]
            ]
        );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function DetailsEvent($id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $URI = config('global.base_api').'/event/'.$id;

        $client = new Client;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/json' , 'Authorization' => 'Bearer '.$access_token];
        try
        {
            $res = $client->get( $URI, $params );
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }

        return json_decode($response);
    }

    static function RegisterConflict($event_json){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/event/conflict/student';
        $res = $client->post( $URI ,
            [
                'headers' => [
                    'Accept' => "application/json",
                    'Content-Type' => "application/json",
                    'Authorization' => 'Bearer '.$access_token
                ],
                'body' => $event_json
            ]
        );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function CourseConflict($event_json){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/event/conflict/tutor';
        $res = $client->post( $URI ,
            [
                'headers' => [
                    'Accept' => "application/json",
                    'Content-Type' => "application/json",
                    'Authorization' => 'Bearer '.$access_token
                ],
                'body' => $event_json
            ]
        );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function TeacherConflict($event_json){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/event/conflict/teacher';
        $res = $client->post( $URI ,
            [
                'headers' => [
                    'Accept' => "application/json",
                    'Content-Type' => "application/json",
                    'Authorization' => 'Bearer '.$access_token
                ],
                'body' => $event_json
            ]
        );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function AcceptEvent($user_id , $event_id , $status){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/'.$user_id.'/event/'.$event_id.'/status';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array('status' => $status );
        $res = $client->post( $URI, $params );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function AddMemberEvent($user_id , $event_id , $members){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/'.$user_id.'/event/'.$event_id.'/member';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array('members' => $members );
        $res = $client->post( $URI, $params );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function RemoveMemberEvent($user_id , $event_id , $member_id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/'.$user_id.'/event/'.$event_id.'/member/'.$member_id;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = ['_method' => 'DELETE'];
        $res = $client->post( $URI, $params );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function ListMemberEvent($user_id , $event_id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/'.$user_id.'/event/'.$event_id.'/member';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $res = $client->get( $URI, $params );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function DeletePermissionsEvent($user_id , $event_id , $permission){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/'.$user_id.'/event/'.$event_id.'/members';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array('permission' => $permission , '_method' => 'DELETE' );
        $res = $client->post( $URI, $params );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function AddPermissionsMemberEvent($user_id , $event_id , $member_id , $permission){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/'.$user_id.'/event/'.$event_id.'/member/'.$member_id.'/permission';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array('permission' => $permission );
        $res = $client->post( $URI, $params );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

    static function ListPermissionsMemberEvent($user_id , $event_id , $member_id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/'.$user_id.'/event/'.$event_id.'/member/'.$member_id.'/permission';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $res = $client->post( $URI, $params );
        $response =  $res->getBody()->getContents();
        return json_decode($response);
    }

}