<?php
/**
 * Created by PhpStorm.
 * User: ladan
 * Date: 9/4/2018
 * Time: 8:31
 */

namespace App\Traits;

use Morilog\Jalali\jDate;
use Carbon\Carbon;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

trait Date
{
    static function toJalali($date){
       return jDate::forge($date)->format('%d %B %Y');
    }
    static function dateView($date , $lang){
        if($lang == 'fa') {
            $date = explode(' ', $date)[0];
            $date = str_replace('-' , '/' , $date);
            return jDate::forge($date)->format('%d %B %Y');
        }else {
            return Carbon::parse($date)->format('Y/M/d');
        }
    }
    static function toTimestamp($date){
        return ( Carbon::parse($date)->timestamp ) * 1000;
    }
    static function milisecondToDate($date)
    {

        $date=Carbon::createFromTimestampUTC(intval($date/1000));

        return $date->format('Y-m-d').'T'.$date->format('h:m:s');
    }
    static function getFarsiCalendar($year , $month , $day ){
        $client = new Client;
        $URI    = 'https://pholiday.herokuapp.com/date/'.$year.'-'.$month.'-'.$day;
        try{
            $res = $client->request( 'GET' , $URI);
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
}