<?php


namespace App\Traits;


use GuzzleHttp\Client;

trait Customer
{
    static function updateCourseGroup($jsonString , $url , $course_key){
        $headers = [
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Authorization' => config('global.yekita_auth')
        ];
        $client = new Client();
        try {
            $res = $client->post( $url.'api/course/group/update' , [ 'headers' => $headers , 'form_params' => [ 'course_key' => $course_key , 'jsonString' =>  $jsonString ]]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
}