<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Validator::extend('phone_number', function($attribute, $value, $parameters)
        {
            if(substr($value, 0, 2) == '09'){
                if (is_numeric($value)) {
                    return true;
                }else{
                    return false;
                }
            }else{
                return false;
            }
        });
        Validator::replacer('phone_number', function ($message, $attribute, $rule, $parameters) {
            return trans('validation.validate_mobile');
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
