<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class CourseAttr extends Model
{
    protected $connection = 'mysql1';
    protected $table = 'course_attr';
    protected $fillable = [ 'course_key' , 'title' , 'certificate_title' ];
    public function scopeLocale($query)
    {
        $lang = App::getLocale();
        return $query->where('lang', $lang);
    }
    public function course()
    {
        return $this->belongsTo(Course::class,'course_key','course_key');
    }
}
