<?php
namespace App\Model;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class BlogTranslate extends Model
{

    use Sluggable;

    protected $table = 'blogs_translate';
    protected $primaryKey = 'id';
    protected $fillable = [ 'blog_id' , 'image' , 'title' , 'sub_title' , 'keyword' , 'visit' , 'description', 'content' , 'lang' ,'meta_description'];
    public function scopeLocale($query)
    {
        return $query->where('lang', App::getLocale());
    }
    public function blog()
    {
        return $this->belongsTo(Blog::class);
    }

    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

}
