<?php

namespace App\Listeners;

use App\Events\BuyLicense;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;

class RegisterArvan
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  BuyLicense  $event
     * @return void
     */
    public function handle(BuyLicense $event)
    {
  
        $client = new Client;
        $url = config('global.arvan_url') . '/domains/' . $event->license->domain . "." . $event->license->suffixdomain;
        
        

        try {
            $res = $client->request('GET', $url, [
                'headers' => [
                    'Authorization' => 'Apikey ' . config('global.arvan_key'), 
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                ]
            ]);   
        }
        catch (ClientException $e) {
            $response = $e->getResponse();
            $error = json_decode($response->getBody()->getContents());
        }

        if(!isset($error)){

            $data = json_decode($res->getBody()->getContents())->data;
        }
        else{
            $client = new Client;
            $url = config('global.arvan_url') . '/domains/dns-service';
            $res = $client->request('POST', $url, [
                'headers' => ['Authorization' => 'Apikey ' . config('global.arvan_key')],
                'form_params' => ['domain' => $event->license->domain . "." . $event->license->suffixdomain]
            ]);
            $data =  json_decode($res->getBody()->getContents())->data;
        }
        
        
    
        $client = new Client;
        $url = config('global.arvan_url') . "/domains/$data->domain/dns-records";

        if(isset($event->license->prefixdomain)){

            $data = $client->request('POST', $url, $this->param($event->license->prefixdomain));

        }else{
            $data = $client->request('POST', $url, $this->param('www'));

            $data = $client->request('POST', $url, $this->param('@'));
        }
    }


    

    public function param($name){
        return [
            'headers' => ['Accept' => 'application/json','Authorization' => 'Apikey ' . config('global.arvan_key')],
            'form_params' => [
                "type" =>  "a",
                "name" =>  $name,
                "value" => [
                    (object) [
                    "ip"=> config('global.server_ip'),
                    "port"=> null,
                    "weight"=> 100,
                    "country"=> ""
                    ]
                ],
                "ttl" =>  120,
                "cloud" =>  false,
                "upstream_https" =>  "default",
                "ip_filter_mode" =>   (object) [
                    "count"=> "single",
                    "order"=> "none",
                    "geo_filter"=> "none"
                ],
            ]
        ];
            
    }
}
