<?php

namespace App\Http\Resources\User;

use App\Exceptions\ServerException;
use App\Http\Requests\User\CouponRequest;
use App\Models\Coupon;
use App\User;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Resources\Json\Resource;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Laravel\Passport\Token;
use Laravel\Passport\TokenRepository;
use Lcobucci\JWT\Parser;

class UserResourceApi extends Resource
{

    protected $parameters;
    protected $user;
    public function __construct(User $user ,array $parameters)
    {
        $this->parameters =$parameters;
        $this->user = $user;
        //parent::__construct($resource);
    }

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->user->id,
            'status' => ($this->user->status==1?true:false) ,
            'name' => $this->user->name,
            'gender' => $this->user->gender,
            'lastname' => $this->user->last_name,
            'email' => $this->user->email,
            'username' => $this->user->username,
            'country' => $this->user->country,
            'city' => $this->user->city,
            'state' => $this->user->state,
            'mobile_number' => $this->user->mobile_number,
            'tel_number' => $this->user->tel_number,
            'address' => $this->user->address1,
            "national_code" =>  $this->user->national_code,
            'zip_code' => $this->user->zip_code,
            'birthday' => $this->user->birthday,
            'account_number' => $this->user->account_number,
            'isCompleted' =>$this->isUserCompleted(),
            'avatar' => $this->addImageUrlToArray($this->user->image_url, "public/upload/users/avatars/"),
            'wallet' => $this->user->wallets
        ];
    }

    private function isUserCompleted()
    {
        $userArray =$this->user->toArray();
        foreach ($this->parameters as $parameter )
        {
           if($parameter == 'avatar'){
               if (!file_exists(public_path(Storage::url("public/upload/users/avatars/" . $this->user->image_url.".jpeg")))){
                   return false;
               }
           }else{
               if ((is_null($userArray[$parameter]) or $userArray[$parameter]=="") and $parameter != 'email' )
               {
                   return false;
               }
           }
        }
        return true;
    }

    private function addImageUrlToArray($avatar, $urlPath)
    {


        if (file_exists(public_path(Storage::url($urlPath . $avatar.".jpeg")))) {
            $filePath = asset(Storage::url($urlPath . $avatar.".jpeg"));
        }
        else {
            $filePath = asset('avatar.jpeg');
        }
        return $filePath;
    }

    public function setDiscountForUser(CouponRequest $request)
    {
        try {
            $user = $this->checkTokenForUser($request->input('access_token'));
            $coupon = new Coupon();
            $coupon->user_id = $user->id;
            $coupon->code = $request->input('code');
            $coupon->save();
            return response()->json(['data' => ['coupon' => new CouponResourceApi($coupon)]])->setStatusCode(201);

        } catch (\Exception $e) {
            if ($e instanceof AuthenticationException)
                throw new ModelNotFoundException('This User Does not exist!');
            throw new ServerException($e->getMessage());
        }
    }
    public function checkTokenForUser($accessToken)
    {
        $bearerToken = $accessToken;
        $jwt = (new Parser())->parse($bearerToken);
        $token = \Illuminate\Support\Facades\Redis::hget('tokens', $jwt->getClaim('jti'));

        if ($token) {
            $token = new Token((array)json_decode($token));

        } else {
            $tokenRepository = new TokenRepository();
            $token = $tokenRepository->find($jwt->getClaim('jti'));

            if (!$token)
                throw new AuthenticationException();
            if ($token->revoked) {
                \Illuminate\Support\Facades\Redis::hdel('tokens', $jwt->getClaim('jti'));
                throw new AuthenticationException();

            }

            \Illuminate\Support\Facades\Redis::hset('tokens', $jwt->getClaim('jti'), json_encode($token));

        }


        $user = \Illuminate\Support\Facades\Redis::hget('users', $token->user_id);


        if ($user) {
            $user = new User(json_decode($user, true));


        } else {
            $user = User::find($token->user_id);
            if (!$user) {
                throw new AuthenticationException();
            }
            \Illuminate\Support\Facades\Redis::hset('users', $token->user_id, json_encode($user));
        }

        return $user;


    }


}
