<?php

namespace App\Http\Resources\License;

use App\Models\User;
use Illuminate\Http\Resources\Json\Resource;
use Illuminate\Support\Facades\Storage;

class LicenseResourceApi extends Resource
{

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'code' =>  $this->code,
            'private_balance' =>  $this->private_balance,
            'halfprivate_balance' =>  $this->halfprivate_balance,
            'public_balance' =>  $this->public_balance,
            'sms_balance' =>  $this->sms_balance,
            'iscompleted' =>  $this->iscompleted,
            'status' => ($this->status==1?true:false) ,
            'domain' =>  str_replace('"', '', $this->domain),
            'has_domain' =>  str_replace('"', '', $this->has_domain),
            'host' =>  str_replace('"', '', $this->host),
            'suffix_domain' =>  str_replace('"', '', $this->suffixdomain),
            'expire_date' =>  $this->expire_date,
            'user_id' =>  $this->user_id,
        ];
    }
}
