<?php

namespace App\Http\Controllers;

use App\Http\Resources\User\UserResourceApi;
use App\Model\ProductsStore;
use App\Model\Transaction;
use App\Model\UpdateSoftware;
use App\Traits\Gateway;
use App\Traits\License;
use App\Traits\Oauth;
use App\Traits\Shop;
use App\Traits\Wallet;
use App\User;
use Carbon\Carbon;
use Dotenv\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Response;


class UserController extends Controller
{
    public function get_access_token_user($mobile)
    {
        $access_token = Oauth::getUserToken($mobile);

        return $access_token;
    }

    public function get_access_token_user_with_password(Request $request)
    {
        $config_parameter = json_encode(array('mobile_number' , 'name' , 'last_name' ,'email' ));

        $parameters = json_decode($config_parameter, true);;
        $phoneNumber = $request->mobile;
        $password = $request->password;
        $client_id = config('global.client_id');
        $client_secret = config('global.client_secret');
        $user = User::where('mobile_number', $phoneNumber)->first();
        if ($user and Hash::check($password, $user->password)) {
            $userRegisteredFromWhichApps = $user->which_apps;

            $clientName = Oauth::whichApp(request()->bearerToken());
            if (!strpos($userRegisteredFromWhichApps, $clientName) and strpos($userRegisteredFromWhichApps, $clientName) !== 0) {
                $userRegisteredFromWhichApps = $userRegisteredFromWhichApps . $clientName;
                $user->which_apps = $userRegisteredFromWhichApps;
                $user->save();
            }


            $response = Oauth::_getAccessToken($phoneNumber, $user->password, $client_id, $client_secret);
            $guzzleresult = json_decode((string)$response->getBody(), true);
            $result = [];
            $result['token_type'] = $guzzleresult['token_type'];
            $result['expires_in'] = $guzzleresult['expires_in'];
            $result['access_token'] = $guzzleresult['access_token'];
            $result['refresh_token'] = $guzzleresult['refresh_token']; 
            return response()->json(['data' => ['user' => new UserResourceApi($user, $parameters), 'access_token' => $result]])->setStatusCode(200); 
        }else
        {
            return response()->json(['data' => 'Model Not Found'])->setStatusCode(Response::HTTP_NOT_FOUND);
        }


    }

    public function update_user(Request $request)
    {
        if(!is_null($request->avatar)){
            $avatar = urldecode($request->avatar);
            $avatar = str_replace( ' ' , '+' , $avatar);
        }else{
            $avatar = null;
        }
        $user_info = Oauth::updateUser($request->user_id, $avatar, $request->name, $request->lastname , $request->gender, $request->birthday, $request->email, $request->national_code , $request->password , $request->country , $request->state , $request->city ,  $request->tel_number , $request->address);
        $user_info = json_decode($user_info);

        if($user_info->code == 200){
            $mobile = $user_info->body->data->mobile_number;
            $avatar = $user_info->body->data->avatar;
            DB::connection('mysql1')->table('teacher_attr')->where('mobile' , $mobile)->update(['avatar' => $avatar]);
        }
        return response()->json($user_info);
    }

    public function update_password(Request $request)
    {
        $user_info = Oauth::updatePassword($request->user_id, $request->password );
        if($user_info->code == 200){
            $mobile = $user_info->body->data->mobile_number;
            $avatar = $user_info->body->data->avatar;
            DB::connection('mysql1')->table('teacher_attr')->where('mobile' , $mobile)->update(['avatar' => $avatar]);
        }
        return response()->json($user_info);
    }

    public function get_basket($currency , $token)
    {
        if($token == 'null'){
            $basket = Shop::basket($currency);
        }else{
            $basket = Shop::basket($currency , $token);
        }
        $public         = ProductsStore::where('code', config('global.SKU_PUBCREDIT_PR'))->get()[0];
        $private        = ProductsStore::where('code', config('global.SKU_PRICREDIT_PR'))->get()[0];
        $half_private   = ProductsStore::where('code', config('global.SKU_HAFPRICREDIT_PR'))->get()[0];
        $sms            = ProductsStore::where('code', config('global.SKU_SMS'))->get()[0];

        $basket->body->public_price       = $public->price;
        $basket->body->private_price      = $private->price;
        $basket->body->half_private_price = $half_private->price;
        $basket->body->sms_price          = $sms->price;

        $basket->body->public_pid       = $public->pid;
        $basket->body->private_pid      = $private->pid;
        $basket->body->half_private_pid = $half_private->pid;
        $basket->body->sms_pid          = $sms->pid;

        return response()->json($basket);
    }

    public function add_to_basket(Request $request)
    {
        $currency   = $request->currency;
        $token      = $request->token;
        $product_id = $request->product_id;
        $quantity   = $request->quantity;
        $license    = $request->license;
        $license_id = ProductsStore::where('code', config('global.SKU_LICENSE'))->get()[0]->pid;
        $custom[$license_id] = $license;
        $basket = Shop::add_to_basket($token , $product_id , $quantity , $currency , null , $custom);

        $public         = ProductsStore::where('code', config('global.SKU_PUBCREDIT_PR'))->get()[0];
        $private        = ProductsStore::where('code', config('global.SKU_PRICREDIT_PR'))->get()[0];
        $half_private   = ProductsStore::where('code', config('global.SKU_HAFPRICREDIT_PR'))->get()[0];
        $sms            = ProductsStore::where('code', config('global.SKU_ASMS'))->get()[0];

        $basket->body->public_price       = $public->price;
        $basket->body->private_price      = $private->price;
        $basket->body->half_private_price = $half_private->price;
        $basket->body->sms_price          = $sms->price;

        $basket->body->public_pid       = $public->pid;
        $basket->body->private_pid      = $private->pid;
        $basket->body->half_private_pid = $half_private->pid;
        $basket->body->sms_pid          = $sms->pid;

        return response()->json($basket);
    }

    public function discount(Request $request)
    {
        $currency       = $request->currency;
        $token          = $request->token;
        $discount       = $request->discount;
        $access_token   = $request->access_token_user;
        $response = Shop::discount($access_token , $currency , $token , $discount);

        return response()->json($response);
    }

    public function del_discount(Request $request)
    {
        $currency       = $request->currency;
        $token          = $request->token;
        $discount       = $request->discount;
        $response = Shop::delete_discount($currency , $token , $discount);

        return response()->json($response);
    }

    public function balance_wallet($user_id)
    {
        $response = Wallet::balance($user_id);
        return response()->json($response);
    }

    public function pay_customer(Request $request)
    {
        $currency     = $request->currency;
        $basket_token = $request->basket_token;
        $mobile       = $request->mobile;
        $user_token   = $request->access_token_user;
        $license      = $request->license;
        $response = Oauth::tokenValidate($user_token);
        if($response->code >= 200 && $response->code < 300){
            if($mobile == $response->body->data->mobile_number){
                $license = License::checkLicense($license);
                if ($license->code >= 200 && $license->code < 300){
                    $basket   = Shop::basket($currency , $basket_token);
                    $basket_info = array_dot($basket->body->data->attributes);
                    $payable     = $basket_info['order.base.price'] + $basket_info['order.base.taxvalue'];
                    if(count(Wallet::balance($response->body->data->id)->body->data->wallet) == 0){
                        $wallet = 0;
                    }else{
                        $wallet = collect(Wallet::balance($response->body->data->id)->body->data->wallet)->where('currency_id' , $currency)->first()->wallet;
                    }
                    $diff   = intval($payable) - intval($wallet);
                    $callback = 'http://'.$license->body->data->domain.'.'.$license->body->data->suffix_domain;

                    session()->put('gateway_target' , $callback);
                    session()->put('user_token' , $user_token);
                    session()->put('basket_token' , $basket_token);
                    session()->put('currency' , $currency);

                    if($diff > 0){
                        if ($diff < 1000) {
                            $amount = 1000;
                        } else {
                            $amount = $diff;
                        }
                        $invoiceID = uniqid(mt_rand(0, 999999), false);
                        $transaction = new Transaction();
                        $transaction->user_id   = $response->body->data->id;
                        $transaction->amount    = $amount;
                        $transaction->invoiceID = $invoiceID;
                        $terminalID = config('global.TerminalID');
                        if ($transaction->save()) {
                            $response_gateway = Gateway::getAccessToken($terminalID, $invoiceID, $amount, route('callback_customer'));
                        }
                        if (!$response_gateway['status']) {
                            $accessToken = $response_gateway['Accesstoken'];
                            return view('dashboard.payment.payment', compact('accessToken', 'terminalID'));
                        } else {
                            return redirect()->back();
                        }
                    }else{
                        $result = Shop::basket_save($user_token , $currency , $basket_token);
                        if ($result->code >= 200 && $result->code < 300) {
                            $order = Shop::create_invoice($user_token , $currency , $basket_token, $result->body->data->id);
                            if ($order->code >= 200 && $order->code < 300) {
                                return Redirect::to($callback.'/dashboard/success_pay');
                            } else {
                                return Redirect::to($callback.'/dashboard/unsuccessful_pay');
                            }
                        } else {
                            return Redirect::to($callback.'/dashboard/unsuccessful_pay');
                        }
                    }
                }
            }
        }else{
            return redirect()->back();
        }
    }

    public function callback_customer(Request $request)
    {
        $respcode = $request->respcode;
        $respmsg = $request->respmsg;
        $amount = $request->amount;
        $invoiceid = $request->invoiceid;
        $terminalid = $request->terminalid;
        $tracenumber = $request->tracenumber;
        $rrn = $request->rrn;//Important For Track
        $digitalreceipt = $request->digitalreceipt;
        $cardnumber = $request->cardnumber;
        $issuerbank = $request->issuerbank;

        $transaction = Transaction::where('invoiceID', $invoiceid)->first();
        $target = session()->get('gateway_target');
        if ($transaction) {
            if ($respcode == 0) {
                if ($transaction->amount == $amount) {
                    $response = Gateway::verifyOrder($terminalid, $digitalreceipt);
                    if (!strcmp($response['status'], "Ok") || !strcmp($response['status'], "Duplicate")) {
                        if (!strcmp($transaction->amount, $response['returnId'])) {
                            $transaction->documentـnumber = $rrn;
                            $transaction->datePaid = Carbon::now();
                            $result = [];
                            $result['respmsg'] = $respmsg;
                            $result['tracenumber'] = $tracenumber;
                            $result['cardnumber'] = $cardnumber;
                            $result['issuerbank'] = $issuerbank;
                            $result['digitalreceipt'] = $digitalreceipt;
                            $transaction->result = implode('_', $result);
                            $transaction->save();
                            $user_token   = session()->get('user_token');
                            $basket_token = session()->get('basket_token');
                            $currency     = session()->get('currency');
                            $charge = Wallet::charge($amount, 'IRR' , $user_token);
                            if ($charge->code >= 200 && $charge->code < 300) {
                                $result = Shop::basket_save($user_token , 'IRR' , $basket_token);
                                if ($result->code >= 200 && $result->code < 300) {
                                    $order = Shop::create_invoice($user_token , $currency , $basket_token, $result->body->data->id);
                                    if ($order->code >= 200 && $order->code < 300) {
                                        return Redirect::to($target.'/dashboard/success_pay');
                                    } else {
                                        return Redirect::to($target.'/dashboard/unsuccessful_pay');
                                    }
                                } else {
                                    return Redirect::to($target.'/dashboard/unsuccessful_pay');
                                }
                                //return Redirect::to($target.'/dashboard/success_pay');
                            } else {
                                return Redirect::to($target.'/dashboard/unsuccessful_pay');
                            }
                        } else {
                            $transaction->result = $respmsg;
                            $transaction->save();
                            return Redirect::to($target.'/dashboard/unsuccessful_pay');
                        }
                    } else {
                        $transaction->result = $respmsg;
                        $transaction->save();
                        return Redirect::to($target.'/dashboard/unsuccessful_pay');
                    }
                } else {
                    $transaction->result = $respmsg;
                    $transaction->save();
                    return Redirect::to($target.'/dashboard/unsuccessful_pay');
                }
            } else {
                $transaction->result = $respmsg;
                $transaction->save();
                return Redirect::to($target.'/dashboard/unsuccessful_pay');
            }
        } else {
            return Redirect::to($target.'/dashboard/unsuccessful_pay');
        }
    }


    public function wallet_charge(Request $request)
    {
        $mobile       = $request->mobile;
        $user_token   = $request->access_token_user;
        $license      = $request->license;
        $response = Oauth::tokenValidate($user_token);
        if($response->code >= 200 && $response->code < 300) {
            if ($mobile == $response->body->data->mobile_number) {
                $license = License::checkLicense($license);
                if ($license->code >= 200 && $license->code < 300) {
                    $callback = 'http://'.$license->body->data->domain.'.'.$license->body->data->suffix_domain;
                    session()->put('gateway_target' , $callback);
                    session()->put('user_token' , $user_token);

                    $invoiceID = uniqid(mt_rand(0, 999999), false);
                    $amount = $request->amount;
                    $transaction = new Transaction();
                    $transaction->user_id   = $response->body->data->id;
                    $transaction->amount    = $amount;
                    $transaction->invoiceID = $invoiceID;
                    $terminalID = config('global.TerminalID');
                    if ($transaction->save()){
                        $response_gateway = Gateway::getAccessToken($terminalID, $invoiceID, $amount, route('wallet_callback'));
                    }
                    if (!$response_gateway['status']) {
                        $accessToken = $response_gateway['Accesstoken'];
                        return view('dashboard.payment.payment', compact('accessToken', 'terminalID'));
                    } else {
                        return Redirect::to($callback.'/dashboard/unsuccessful_pay');
                    }
                }
            }
        }
    }

    public function wallet_callback(Request $request)
    {
        $respcode = $request->respcode;
        $respmsg = $request->respmsg;
        $amount = $request->amount;
        $invoiceid = $request->invoiceid;
        $terminalid = $request->terminalid;
        $tracenumber = $request->tracenumber;
        $rrn = $request->rrn;//Important For Track
        $digitalreceipt = $request->digitalreceipt;
        $cardnumber = $request->cardnumber;
        $issuerbank = $request->issuerbank;
        $transaction = Transaction::where('invoiceID', $invoiceid)->first();
        $target = $request->session()->get('gateway_target');
        if ($transaction) {
            if ($respcode == 0) {
                if ($transaction->amount == $amount) {
                    $response = Gateway::verifyOrder($terminalid, $digitalreceipt);
                    if (!strcmp($response['status'], "Ok") || !strcmp($response['status'], "Duplicate")) {
                        if (!strcmp($transaction->amount, $response['returnId'])) {
                            $transaction->documentـnumber = $rrn;
                            $transaction->datePaid = Carbon::now();
                            $result = [];
                            $result['respmsg'] = $respmsg;
                            $result['tracenumber'] = $tracenumber;
                            $result['cardnumber'] = $cardnumber;
                            $result['issuerbank'] = $issuerbank;
                            $result['digitalreceipt'] = $digitalreceipt;
                            $transaction->result = implode('_', $result);
                            $transaction->save();
                            $user_token   = session()->get('user_token');
                            $charge = Wallet::charge($amount, 'IRR' , $user_token);
                            if ($charge->code >= 200 && $charge->code < 300) {
                                return Redirect::to($target.'/dashboard/success_pay');
                            } else {
                                return Redirect::to($target.'/dashboard/unsuccessful_pay');
                            }
                        } else {
                            $transaction->result = $respmsg;
                            $transaction->save();
                            return Redirect::to($target.'/dashboard/unsuccessful_pay');
                        }
                    } else {
                        $transaction->result = $respmsg;
                        $transaction->save();
                        return Redirect::to($target.'/dashboard/unsuccessful_pay');
                    }
                } else {
                    $transaction->result = $respmsg;
                    $transaction->save();
                    return Redirect::to($target.'/dashboard/unsuccessful_pay');
                }
            } else {
                $transaction->result = $respmsg;
                $transaction->save();
                return Redirect::to($target.'/dashboard/unsuccessful_pay');
            }
        } else {
            return Redirect::to($target.'/dashboard/unsuccessful_pay');
        }
    }

    public function update_software(Request $request)
    {
        $code = $request->last_update;
        $last_update = UpdateSoftware::where('code' , '>' , $code)->where('publish' , 'active')->get();
        return response()->json($last_update);
    }

    public function download_application($type)
    {

        $last_version = DB::connection('mysql1')->table('update_application')
            ->select('link')
            ->orderBy('id' , 'desc')
            ->where('application', $type)
            ->where('status', 1)
            ->first();
        return Redirect::to($last_version->link);

    }
}
