<?php

namespace App\Http\Controllers;

use App\Events\BuyLicense;
use App\Model\Product;
use App\Model\Transaction;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Traits\Date;
use Illuminate\Support\Str;

class TransactionController extends Controller
{
    //
    public function verify_zarinpal(Request $request){
        $MerchantID = 'XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX';
        $Authority = $request->Authority;
        $transaction = Transaction::where('documentـnumber',$Authority)->first();
        $Amount = $transaction->amount;

        if ($request->Status == 'OK') {

            $client = new \SoapClient('https://sandbox.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);

            $result = $client->PaymentVerification(
            [
            'MerchantID' => $MerchantID,
            'Authority' => $Authority,
            'Amount' => $Amount,
            ]
            );
            if ($result->Status == 100) {
                $sms = Product::where([['type','sms'],['status','1']])->first()->name;
                $sms =  (int) filter_var($sms, FILTER_SANITIZE_NUMBER_INT);
                $transaction->datePaid = Carbon::Today();
                $transaction->result = "پرداخت با موفقیت انجام شد";
                $transaction->update();
                $platform = json_decode($transaction->platform);
                $expire_date = Product::find($platform->platform->platform_id)->name;
                $expire_date = (int) filter_var($expire_date, FILTER_SANITIZE_NUMBER_INT);
                $domain = $platform->domain;
                $user = User::find($transaction->user_id);
                $license = $user->licenses()->create([
                    'code' => $random = Str::random(20),
                    'prefixdomain' => $domain->prefix ? $domain->prefix : null,
                    'domain' => $domain->domain,
                    'suffixdomain' => $domain->suffix,
                    'host' => 'package_a',
                    'has_domain' => $platform->domain->has_domain,
                    'expire_date' => Carbon::now()->addMonths($expire_date),
                    'iscompleted' => 1,
                    'sms_balance' => $sms,
                    'nic_id' => $platform->domain->nic_id,
                    'email' => $platform->platform->email
                ]);
                event(new BuyLicense($license)); 
                return view('front.payment-result',compact('transaction'));
            } else {
                return view('front.payment-result',compact('transaction'));
            }
            
        }else{
            return view('front.payment-result',compact('transaction'));
        }
    }
}
