<?php namespace App\Http\Controllers;

use App\Model\TeacherAttrModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

/**
 * Class TeacherController
 * @package App\Http\Controllers
 */
class TeacherController extends Controller
{
    /**
     * @param Request $request
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $lang = App::getLocale();
        $teachers = TeacherAttrModel::Where('status', 'enable')->Where('display', 'show')->Where('lang', $lang)
            ->Where('avatar', 'like', '%storage%')->orderBy('rate')->select('full_name', 'avatar')->paginate(36);

        return view('front.teachers', compact('teachers', 'lang'));
    }
}
