<?php

namespace App\Http\Controllers;

use App\Model\ProvinceModel;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Illuminate\Support\Facades\DB;

class MapController extends Controller
{
    public function __construct()
    {

    }

    public function index(Request $request)
    {
        $lang    = App::getLocale();
        $page_title = 'جستجوی دوره ها در نقشه';
        $ip = \Request::ip();
        $ip = '93.118.172.17';
        $url = "http://ip-api.com/json/";
        $client = new Client(['base_uri' => $url]);
        try {
            $response = $client->request('GET', $ip);
        } catch (GuzzleException $e) {
            return null;
        }
        $location_info = json_decode((string)$response->getBody(), true);
        $location_info = (object) $location_info;
        $province = ProvinceModel::all();
        return view('front.map.index' ,compact('lang'  , 'page_title' , 'location_info' , 'province' ));
    }

    public function courses(Request $request)
    {
        $lang = $request->lang;
        $lat  = $request->lat;
        $lon  = $request->lon;

        $right_top_lat = $lat + 0.03;
        $right_top_lon = $lon + 0.15;

        $left_bottom_lat = $lat - 0.03;
        $left_bottom_lon = $lon - 0.15;

        $courses = DB::connection('mysql1')->table('courses')
            ->join('course_attr','courses.course_key' , '=','course_attr.course_key' )
            ->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' )
            ->select('courses.course_key' , 'courses.base_url' , 'courses.situation' , 'courses.date_start'  , 'courses.date_end' , 'courses.lat'  , 'courses.long' ,'course_attr.title')
            ->where('courses.state' , 1)
            ->where('course_attr.lang' , $lang)
            ->where('courses.lat' , '<' , $right_top_lat)
            ->where('courses.long' , '<' , $right_top_lon)
            ->where('courses.lat' , '>' , $left_bottom_lat)
            ->where('courses.long' , '>' , $left_bottom_lon)
            ->orderBy('courses.id' , 'desc')
            ->get();
        $locations = array();
        $loc = array();
        foreach ($courses as $value){
            $latlon = $value->lat.$value->long;
            $index = array_search($latlon , $loc);
            if($index > -1){
                if (!strpos($locations[$index][0], $value->course_key)) {
                    $title = '<a target="_blank" href="'.$value->base_url.'course/'.$value->course_key.'">'.$value->title.'</a><br/>';
                    $new_title = $locations[$index][0].$title;
                    $locations[$index] = array($new_title , $value->lat , $value->long);
                }
            }else{
                $title = '<a target="_blank" href="'.$value->base_url.'course/'.$value->course_key.'">'.$value->title.'</a><br/>';
                $array = array($title , $value->lat , $value->long);
                array_push($locations , $array);
                array_push($loc , $latlon);
            }
        }

        return response()->json($locations);
    }
}
