<?php

namespace App\Http\Controllers;

use App\Model\Income;
use App\Model\Transaction;
use App\Traits\Oauth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class IncomeController extends Controller
{
    public function deposit(Request $request)
    {
        $mobile         = $request->mobile;
        $amount         = $request->amount;
        $type           = $request->type;
        $conductor      = $request->conductor;
        $conductor_mobile= $request->conductor_mobile;
        $course         = $request->course;
        $invoiceID      = $request->invoiceID;
        $transactions   = $request->transactions;
        $IBAN           = $request->IBAN;
        $user_id = Oauth::getUserToken($mobile)->body->data->user->id;

        Transaction::create([
            'user_id' => $user_id,
            'amount' => $amount,
            'type' => $type,
            'conductor' => $conductor,
            'course' => $course,
            'invoiceID' => $invoiceID,
            'documentـnumber' => $transactions
        ]);

        if($type == 'course_reg_ipg_gateway'){

            $balance = DB::table('income')
                ->select('id' , 'balance')
                ->where('mobile' , $conductor_mobile)
                ->first();
            if(isset($balance->id)){
                $new_balance = $balance->balance + $amount;
                $balance->balance = $new_balance;
                $balance->IBAN = $IBAN;
                $balance->save();
            }else{
                Income::create([
                    'mobile' => $conductor_mobile,
                    'balance' => $amount,
                    'IBAN' => $IBAN,
                ]);
            }

        }

    }

    public function withdraw(Request $request)
    {

    }
}
