<?php namespace App\Http\Controllers;

use App\Model\Contact;
use App\Model\ProductsStore;
use App\Model\Slider;
use App\Model\License;
use App\Model\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redis;
use Iodev\Whois\Whois;
use Validator;

/**
 * Class HomeController
 * @package App\Http\Controllers
 */
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lang    = App::getLocale();
        $group   = Lang::get('course_group');
        $conductors = Redis::get('conductors');
        if(is_null($conductors)){
            $conductors = DB::connection('mysql1')->table('conductor')
                ->select('conductor_key' , 'conductor' , 'logo')
                ->where('conductor', '!=' , null)
                ->where('lang', $lang)
                ->get();
            Redis::set('conductors' , $conductors);
        }else{
            $conductors = json_decode($conductors);
        }

        $amount = '50000-5000000';

        $suffix = ProductsStore::where('type', 'SUFFIXDOMAIN')
            ->orderBy('price', 'asc')
            ->get();

        $pamphlets = DB::connection('mysql1')->table('pamphlets')
            ->leftjoin('courses', 'pamphlets.course_key', '=', 'courses.course_key')
            ->leftjoin('course_attr','pamphlets.course_key' , '=','course_attr.course_key')
            ->select('courses.id', 'course_attr.title','pamphlets.description','pamphlets.type')
            ->where('courses.state', 1)
            ->where('pamphlets.status', 'publish')
            ->where('course_attr.lang' , $lang)
            ->distinct()
            ->limit(12)
            ->get();

        $courses['newest'] = DB::connection('mysql1')->table('courses')
            ->join('course_attr','courses.course_key' , '=','course_attr.course_key' )
            ->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' )
            ->select( 'courses.id', 'courses.course_key', 'courses.base_url', 'courses.situation', 'courses.date_start', 'courses.date_end', 'courses.date_register' , 'courses.level' , 'courses.rate', 'courses.popular', 'courses.capacity' , 'courses.image' , 'courses.cost_register as cost', 'courses.create_date', 'course_attr.title', 'course_attr.certificate_title', 'course_attr.lang', 'course_attr.description', 'conductor.conductor')
            ->where('courses.state' , 1)
            ->where('course_attr.lang' , $lang)
            ->where('conductor.lang' , $lang)
            ->orderBy('courses.create_date', 'DESC')
            ->distinct()
            ->paginate(12);

        $courses['popular'] = DB::connection('mysql1')->table('courses')
            ->join('course_attr','courses.course_key' , '=','course_attr.course_key' )
            ->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' )
            ->select( 'courses.id', 'courses.course_key', 'courses.base_url', 'courses.situation', 'courses.date_start', 'courses.date_end', 'courses.date_register' , 'courses.level' , 'courses.rate', 'courses.popular', 'courses.capacity' , 'courses.image' , 'courses.cost_register as cost', 'courses.create_date', 'course_attr.title', 'course_attr.certificate_title', 'course_attr.lang', 'course_attr.description', 'conductor.conductor')
            ->where('courses.state' , 1)
            ->where('course_attr.lang' , $lang)
            ->where('conductor.lang' , $lang)
            ->orderBy('popular', 'DESC')
            ->orderBy('courses.create_date', 'DESC')
            ->distinct()
            ->paginate(12);

        $courses['most'] = DB::connection('mysql1')->table('courses')
            ->join('course_attr','courses.course_key' , '=','course_attr.course_key' )
            ->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' )
            ->select( 'courses.id', 'courses.course_key', 'courses.base_url', 'courses.situation', 'courses.date_start', 'courses.date_end', 'courses.date_register' , 'courses.level' , 'courses.rate', 'courses.popular', 'courses.capacity' , 'courses.image' , 'courses.cost_register as cost', 'courses.create_date', 'course_attr.title', 'course_attr.certificate_title', 'course_attr.lang', 'course_attr.description', 'conductor.conductor')
            ->where('courses.state' , 1)
            ->where('course_attr.lang' , $lang)
            ->where('conductor.lang' , $lang)
            ->orderBy('rate', 'DESC')
            ->orderBy('courses.create_date', 'DESC')
            ->distinct()
            ->paginate(12);

        $courses['free'] = DB::connection('mysql1')->table('courses')
            ->join('course_attr','courses.course_key' , '=','course_attr.course_key' )
            ->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' )
            ->select( 'courses.id', 'courses.course_key', 'courses.base_url', 'courses.situation', 'courses.date_start', 'courses.date_end', 'courses.date_register' , 'courses.level' , 'courses.rate', 'courses.popular', 'courses.capacity' , 'courses.image' , 'courses.cost_register as cost', 'courses.create_date', 'course_attr.title', 'course_attr.certificate_title', 'course_attr.lang', 'course_attr.description', 'conductor.conductor')
            ->where('courses.state' , 1)
            ->where('course_attr.lang' , $lang)
            ->where('conductor.lang' , $lang)
            ->where('courses.cost_register', 0)
            ->orderBy('courses.create_date', 'DESC')
            ->distinct()
            ->paginate(12);

        $blog = DB::table('blogs')
            ->join('blogs_translate','blogs_translate.blog_id' , '=','blogs.id' )
            ->select('blogs.id', 'blogs_translate.title', 'blogs_translate.content','blogs_translate.image' ,'blogs_translate.visit' ,'blogs_translate.description' ,'blogs_translate.created_at')
            ->where('blogs.status' , 'active')
            ->where('blogs_translate.lang' , $lang)
            ->orderBy('blogs.updated_at', 'DESC')
            ->paginate(12);

        $teachers = DB::connection('mysql1')->table('teacher_attr')->where('status' , 'enable')->where('display' , 'show')->where('lang' , 'fa')->where('avatar','like', '%storage%')->orderBy(DB::raw('RAND()'))->limit(12)->select('id' , 'full_name' , 'avatar')->get();
        $conductors_slider = DB::connection('mysql1')->table('conductor')->where('status' , 'enable')->where('logo' ,'!=' ,null)->where('display' , 'show')->where('lang' , 'fa')->orderBy(DB::raw('RAND()'))->limit(12)->select('id' , 'conductor' , 'logo')->get();

        $sort = 'new';
        $course_type = 'all';
        return view('front.home' ,compact('blog' , 'courses' , 'group' , 'conductors' , 'amount' , 'lang' , 'suffix' ,'sort' , 'course_type' , 'teachers' , 'conductors_slider','pamphlets' ));
    }

    public function about()
    {
        $lang    = App::getLocale();
        $page_title = 'درباره ما';
        return view('front.about' ,compact('lang'  , 'page_title' ));
    }
    public function privacy()
    {
        $lang    = App::getLocale();
        $page_title = 'قوانین و مقررات';
        return view('front.privacy' ,compact('lang'  , 'page_title' ));
    }

    public function privacypolicy()
    {
	$lang    = App::getLocale();
        $page_title = 'حفظ حریم شخصی کاربران:';
        return view('front.privacypolicy' ,compact('lang', 'page_title' ));
    }

    public function contact()
    {
        $lang    = App::getLocale();
        $page_title = 'تماس با ما';
        return view('front.contact' ,compact('lang' , 'page_title' ));
    }

    public function contact_store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'first_name' => [
                'required',
                'max:50'
            ],
            'last_name' => [
                'required',
                'max:100'
            ],
            'email' => [
                'required',
                'max:100',
                'email'
            ],
            'text' => [
                'required',
                'max:600'
            ]
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }else{
            Contact::create([
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'text' => $request->text
            ]);
//            Mail::to('yekitaapp@gmail.com')
//                ->queue(new ContactShipped($request));
            return redirect()->back()->with('alert' , 'پیام شما با موفقیت ثبت شد');
        }
    }

    public function check_domain(Request $request)
    {
        $suffix = strtolower($request->suffix);
        $name   = strtolower($request->domain);
        $domain = $name.'.'.$suffix;
        $exist = License::where([['domain', $name],['suffixdomain',$suffix]])->count();
        if($name != ''){
            $validator = Validator::make($request->all(), [
                'domain' =>[
                    'regex:/^[0-9A-Za-z-]+$/'
                ]
            ]);
            if($exist == 0){
                if ($validator->fails()) {
                    $status = 2;
                }else{
                    if ( Whois::create()->isDomainAvailable($domain) ) {
                       $status = 1;
                    }
                    else {
                        $status = 0;
                    }
                }
            }else{
                $status = 0;
            }
        }else{
            $status = 3;
        }

        return response()->json(array('status' => $status , 'name' => $name , 'suffix' => $request->suffix ));
    }

    public function search_conductor(Request $request)
    {
        $word = $request->word;
        $conductors = DB::connection('mysql1')->table('conductor')->where('status' , 'enable')->where('display' , 'show')->where('lang' , 'fa')->where('conductor' , 'like' , '%'.$word.'%' )->orderBy('sort' , 'asc')->limit(100)->select('id' , 'conductor' , 'logo')->get();
        return response()->json( array('status' => 1 , 'value' => $conductors  ) );
    }

    public function search_teacher(Request $request)
    {
        $word = $request->word;
        $teachers = DB::connection('mysql1')->table('teacher_attr')->where('status' , 'enable')->where('display' , 'show')->where('lang' , 'fa')->where('full_name' , 'like' , '%'.$word.'%' )->orderBy('rate' , 'desc')->limit(100)->select('id' , 'full_name' , 'avatar')->get();
        return response()->json( array('status' => 1 , 'value' => $teachers  ) );
    }

    public function number_format(Request $request){
        $price = number_format($request->new_price);
        return response()->json(array('status' => 1 , 'price' => $price));
    }

    public function rules()
    {
        $page_title = 'قوانین استفاده از محصولات نرم افزاری شرکت سیمرغ';
        $lang    = App::getLocale();
        return view('front.rules' ,compact( 'lang' , 'page_title'));
    }

    public function application()
    {
        $lang    = App::getLocale();
        $blog = DB::table('blogs')
            ->join('blogs_translate','blogs_translate.blog_id' , '=','blogs.id' )
            ->select('blogs.id', 'blogs_translate.title', 'blogs_translate.content','blogs_translate.image' ,'blogs_translate.visit' ,'blogs_translate.description' ,'blogs_translate.created_at','blogs_translate.slug')
            ->where('blogs.status' , 'active')
            ->where('blogs_translate.lang' , $lang)
            ->limit(8)->get();
        $sliders = Slider::all()->sortBy('order');
        $platforms = Product::where('type','پلتفرم')->get();
        $page_title = 'دانلود';
        return view('front.application' ,compact( 'lang' , 'page_title','blog','sliders','platforms'));
    }

    public function desktop()
    {
        $page_title = 'دانلود';
        $lang    = App::getLocale();
        return view('front.desktop' ,compact( 'lang' , 'page_title'));
    }

    public function price()
    {
        $lang    = App::getLocale();
        $page_title = 'تعرفه';
        return view('front.price' ,compact('lang' , 'page_title' ));
    }
    public function download()
    {
        $lang    = App::getLocale();
        $page_title = 'دانلود';
        return view('front.download' ,compact('lang' , 'page_title' ));
    }

}
