<?php

namespace App\Http\Controllers\Dashboard;

use App\Model\Transaction;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Gateway;
use App\Traits\Wallet;
use Illuminate\Support\Facades\App;

class WalletController extends Controller
{
    use Gateway;
    use Wallet;

    public function __construct()
    {

    }

    public function index()
    {
        $language = App::getLocale();
        $page_title = 'کیف پول';
        $user_id  = session()->get('user_information')->id;
        if(count(Wallet::balance($user_id)->body->data->wallet) == 0){
            $wallet = 0;
        }else{

            $wallet     = collect(Wallet::balance($user_id)->body->data->wallet)->where('currency_id' , 'IRR')->first()->wallet;
        }
        $wallet = number_format(intval($wallet));
        return view('dashboard.wallet.index', compact('page_title', 'language', 'wallet'));
    }

    public function charge(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'amount' => [
                'required',
                'numeric',
                'min:1000'
            ]
        ]);
        if ($validator->fails()) {
            return redirect(route('dash_wallet'))
                ->withErrors($validator)
                ->withInput();
        }
        $request->session()->put('gateway_target', 'dash_wallet');
        $invoiceID = uniqid(mt_rand(0, 999999), false);
        $amount = $request->amount;
        $transaction = new Transaction();
        $transaction->user_id = session()->get('user_information')->id;
        $transaction->amount = $amount;
        $transaction->invoiceID = $invoiceID;
        $terminalID = config('global.TerminalID');
        if ($transaction->save())
            $response = Gateway::getAccessToken($terminalID, $invoiceID, $amount, route('payment_callback'));
        if (!$response['status']) {
            $accessToken = $response['Accesstoken'];
            return view('dashboard.payment.payment', compact('accessToken', 'terminalID'));
        } else
            return redirect()->back()->with('respmsg', 'عملیات با خطا مواجه شد.');
    }

    public function paymentCallback(Request $request)
    {
        $respcode = $request->respcode;
        $respmsg = $request->respmsg;
        $amount = $request->amount;
        $invoiceid = $request->invoiceid;
        $terminalid = $request->terminalid;
        $tracenumber = $request->tracenumber;
        $rrn = $request->rrn;//Important For Track
        $digitalreceipt = $request->digitalreceipt;
        $cardnumber = $request->cardnumber;
        $issuerbank = $request->issuerbank;
        $transaction = Transaction::where('invoiceID', $invoiceid)->first();
        $target = $request->session()->get('gateway_target');
        if ($transaction) {
            if ($respcode == 0) {
                if ($transaction->amount == $amount) {
                    $response = Gateway::verifyOrder($terminalid, $digitalreceipt);
                    if (!strcmp($response['status'], "Ok") || !strcmp($response['status'], "Duplicate")) {
                        if (!strcmp($transaction->amount, $response['returnId'])) {
                            $transaction->documentـnumber = $rrn;
                            $transaction->datePaid = Carbon::now();
                            $result = [];
                            $result['respmsg'] = $respmsg;
                            $result['tracenumber'] = $tracenumber;
                            $result['cardnumber'] = $cardnumber;
                            $result['issuerbank'] = $issuerbank;
                            $result['digitalreceipt'] = $digitalreceipt;
                            $transaction->result = implode('_', $result);
                            $transaction->save();
                            $user_token   = session()->get('user_token');
                            $charge = Wallet::charge($amount, 'IRR' , $user_token);
                            if ($charge->code >= 200 && $charge->code < 300) {
                                return redirect()->route($target)->with('respmsg', $respmsg)->with('status', 1);
                            } else {
                                return redirect()->route($target)->with('respmsg', 'عملیات با خطا مواجه شد. کد پیگیری شما :' . $rrn)->with('status', -1);
                            }
                        } else {
                            $transaction->result = $respmsg;
                            $transaction->save();
                            return redirect()->route($target)->with('respmsg', $respmsg)->with('status', -1);
                        }
                    } else {
                        $transaction->result = $respmsg;
                        $transaction->save();
                        return redirect()->route($target)->with('respmsg', $respmsg)->with('status', -1);
                    }
                } else {
                    $transaction->result = $respmsg;
                    $transaction->save();
                    return redirect()->route($target)->with('respmsg', $respmsg)->with('status', -1);
                }
            } else {
                $transaction->result = $respmsg;
                $transaction->save();
                return redirect()->route($target)->with('respmsg', $respmsg)->with('status', -1);
            }
        } else {
            return redirect()->route($target)->with('respmsg', 'عملیات با خطا مواجه شد.')->with('status', -1);
        }
    }
}
