<?php

namespace App\Http\Controllers\Dashboard;

use function App\Http\pars_attributes;
use App\Model\ProductsStore;
use App\Traits\Date;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Shop;
use Illuminate\Support\Facades\App;
use App\Traits\Gateway;

class ShopController extends Controller
{
    use Shop;
    use Gateway;
    public function __construct(){

    }
    public function index(Request $request){
        $language = App::getLocale();
        $page_title = 'خرید سامانه یکیتا';
        if($request->session()->has('basket_token')){
            $token = $request->session()->get('basket_token');
            $basket = Shop::basket('IRR' , $token);
            if($basket->code < 200 || $basket->code >= 300){
                $basket = Shop::basket('IRR');
                $request->session()->put('basket_token', $basket->body->meta->csrf->value);
            }
        }else{
            $basket = Shop::basket('IRR');
            $request->session()->put('basket_token', $basket->body->meta->csrf->value);
        }
        Shop::parse_product_json();
        $pr = ProductsStore::all();
        $product = [];
        foreach ($pr as $value){
            $product[$value->code]['pid']   = $value->pid;
            $product[$value->code]['name']  = $value->name;
            $product[$value->code]['code']  = $value->code;
            $product[$value->code]['type']  = $value->type;
            $product[$value->code]['price'] = $value->price;
            $product[$value->code]['tax']   = $value->tax;
        }
        if($basket->code >= 200 && $basket->code < 300){
            $basket = array_dot($basket->body->data->attributes);
            $amount = number_format(floor( $basket['order.base.price']));
        }else{
            return view('dashboard.shop.index' , compact( 'page_title' , 'language' ))->with('error','error');
        }
        return view('dashboard.shop.index' , compact( 'page_title' , 'language' , 'basket' , 'product' , 'amount' ));
    }
    public function add_credit_basket(Request $request){
        $token = $request->session()->get('basket_token_credit');
        if($request->public > 0){
            $config['2'] = $request->public;
        }
        if($request->private > 0){
            $config['3'] = $request->private;
        }
        if($request->half_private > 0){
            $config['4'] = $request->half_private;
        }
        $custom[''] = '';
        Shop::add_to_basket($token , $request->product , 1 , 'IRR' , $config , $custom);
        return redirect('dashboard/shop');
    }
    public function add_sms_basket(Request $request){
        $token = $request->session()->get('basket_token_credit');
        $custom['21'] = $request->key;
        Shop::add_to_basket($token , 7 , $request->sms , 'IRR' , null , $custom);
        return redirect(route('dash_sms_assigning' , $request->key));
    }
    public function add_to_basket(Request $request){
        $token = $request->session()->get('basket_token');
        if($request->type1 > 0){
            $config['2'] = $request->type1;
        }
        if($request->type2 > 0){
            $config['3'] = $request->type2;
        }
        if($request->type3 > 0){
            $config['4'] = $request->type3;
        }
        if($request->sms > 0){
            $config['5'] = $request->sms;
        }
        $config[$request->postfix] = '1';
        $config[$request->has_domain] = '1';
        $config[$request->hosting] = '1';
        Shop::add_to_basket($token , $request->product , 1 , 'IRR' , $config);
        return redirect('dashboard/shop');
    }
    static function delete_product(Request $request , $id){
        $token = $request->session()->get('basket_token');
        $basket = Shop::delete_product($token , 'IRR' , $id);
        if(count($basket->body->included) > 0){
            return redirect(route('dash_cart'));
        }else{
            return redirect(route('dash_shop'));
        }
    }
    public function basket(Request $request){
        $language = App::getLocale();
        $page_title = 'سبد خرید';
        $token = $request->session()->get('basket_token');
        $basket = Shop::basket('IRR' , $token);
        if($basket->code < 200 || $basket->code >= 300){
            $basket = Shop::basket('IRR');
            $request->session()->put('basket_token', $basket->body->meta->csrf->value);
        }
        if($basket->code < 200 || $basket->code >= 300){
            return view('dashboard.shop.cart' , compact( 'page_title' , 'language' ))->with('error','ggujhgu');
        }
        $basket_price = number_format(intval(pars_attributes($basket->body->data->attributes)['order.base.price']));
        $n = 0;
        $product = [];
        foreach ($basket->body->included as $key => $value){
            if($value->type != "basket/coupon" && $value->type != "basket/address"){
                $product_details = pars_attributes($value->attributes);
                if($product_details['order.base.product.prodcode'] != 'DISCOUNT'){
                    $product[$n]['id']          = $product_details['order.base.product.productid'];
                    $product[$n]['basket_id']   = $value->id;
                    $product[$n]['code']        = $product_details['order.base.product.prodcode'];
                    $product[$n]['name']        = $product_details['order.base.product.name'];
                    $product[$n]['price']       = number_format(intval($product_details['order.base.product.price']));
                    $product[$n]['details']     = $value->attributes->attribute;
                    $n++;
                }
            }
        }
        return view('dashboard.shop.cart' , compact( 'page_title' , 'language' , 'basket_price' , 'product'));
    }

    public function discount(Request $request)
    {
        $token = $request->session()->get('basket_token');
        $user_token = session()->get('user_token');
        $discount = Shop::discount($user_token , 'IRR' , $token , $request->discount);
        $array = explode('/' , $discount->header[0]);
        if($request->session()->has('discount')){
            $dis = $request->session()->get('discount');
            $dis[$array[0]] = $array[1];
            $request->session()->put('discount' , $dis);
        }else{
            $dis = array($array[0] => $array[1]);
            $request->session()->put('discount' , $dis);
        }
        return redirect(route('dash_cart'));
    }
    public function discount_delete(Request $request , $id)
    {
        $token = $request->session()->get('basket_token');
        Shop::delete_discount('IRR' , $token , $id);
        $dis = $request->session()->get('discount');
        unset($dis[$id]);
        $request->session()->put('discount' , $dis);
        return redirect(route('dash_cart'));
    }
    public function save_basket(Request $request)
    {
        $token = $request->session()->get('basket_token');
        $user_token = session()->get('user_token');
        $order = Shop::basket_save($user_token ,'IRR' , $token);
        return redirect(route('dash_order' , $order->body->data->id));
    }
    public function order(Request $request , $id){
        $language = App::getLocale();
        $page_title = 'سبد خرید';
        $token = $request->session()->get('basket_token');
        $user_info  = $request->session()->get('user_information');
        $basket = Shop::basket('IRR' , $token);
        $basket_details = pars_attributes($basket->body->data->attributes);
        if($language == 'fa'){
            $create_date = Date::toJalali(date('Y/m/d'));
        }else{
            $create_date = date('Y/m/d');
        }
        $discount = array();
        foreach ($basket->body->included as $value){
            if($value->type != "basket/coupon") {
                if (pars_attributes($value->attributes)['order.base.product.prodcode'] == config('global.SKU_DISCOUNT')) {
                    $discount[pars_attributes($value->attributes)['order.base.product.name']] = $value->attributes;
                }
            }
        }
        foreach ($basket->body->included as $key => $value){
            if($value->type != "basket/coupon"){
                $product_details = pars_attributes($value->attributes);
                if($product_details['order.base.product.prodcode'] != config('global.SKU_DISCOUNT')){
                    $product_name = $product_details['order.base.product.prodcode'];
                    $discount_details = null;
                    if(isset($discount[$product_name])){
                        $discount_details = $discount[$product_name];
                    }
                    $value->discount = $discount_details;
                }else{
                    unset($basket->body->included[$key]);
                }
            }else{
                unset($basket->body->included[$key]);
            }
        }
        $basket = pars_attributes($basket->body->included);
        return view('dashboard.shop.order' , compact( 'page_title' , 'language' , 'basket' , 'basket_details' , 'create_date' , 'user_info' , 'id'));
    }
    public function pay(Request $request , $id)
    {
        $token = $request->session()->get('basket_token');
        $user_token = session()->get('user_token');
        Shop::create_invoice($user_token ,'IRR' , $token , $id);
        return redirect(route('dash_licenses'));
    }
}
