<?php namespace App\Http\Controllers\Dashboard;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Validator;
use App\Traits\Oauth;
use Illuminate\Support\Facades\App;
use App\Traits\Date;

/**
 * Class ProfileController
 * @package App\Http\Controllers\Dashboard
 */
class ProfileController extends Controller
{
    use Date;
    use Oauth;

    /**
     * @param Request $request
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request){
        $language   = App::getLocale();
        $user_info   = session()->get('user_information');
        $request->session()->put('user_information' , $user_info);
        $birth = (object)array();
        $birth->timestamp = Date::toTimestamp($user_info->birthday , 'en');
        if(is_null($user_info->birthday)){
            $birth->date = null;
        }else{
            if($language == 'fa'){
                $birth->date = Date::toJalali($user_info->birthday);
            }else{
                $birth->date = explode(' ' , $user_info->birthday)[0];
            }
        }

        $page_title = 'اطلاعات شخصی';
        return view('dashboard.profile.index' , compact('user_info' , 'page_title' , 'language' , 'birth'));
    }

    /**
     * @param Request $request
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getManagePassword(Request $request){
        $language   = App::getLocale();
        $page_title = 'مدیریت رمز عبور';
        return view('dashboard.profile.password' , compact( 'page_title' , 'language' ));
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector|void
     */
    public function update_user(Request $request){
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'lastname' => 'required',
            'email' => 'required|email',
            'birthday' => 'required',
            'gender' => 'required|in:male,female'
        ]);
        if ($validator->fails()) {
            return redirect('dashboard/profile')
                ->withErrors($validator)
                ->withInput();
        }
        $user_id = $request->session()->get('user_information')->id;
        $respons = Oauth::updateUser($user_id , $request->avatar , $request->name , $request->lastname , $request->gender , $request->birthday , $request->email);
        if($respons->code == 200){
            $request->session()->put('user_information', $respons->body->data);
            return redirect('dashboard/profile');
        }else{
            return redirect('dashboard/profile')->with('error' , json_decode($respons->error)->meta->error_message);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector|void
     */
    public function postUpdatePassword(Request $request){
        $validator = Validator::make($request->all(), [
            'password' => 'required|confirmed|min:6',
            'password_confirmation' => 'required|min:6'
        ]);
        if ($validator->fails()) {
            return redirect(route('dash_manage_password'))
                ->withErrors($validator)
                ->withInput(Input::except('password', 'password_confirmation'));
        }else {
            $user_id = $request->session()->get('user_information')->id;
            $respons = Oauth::updatePassword($user_id, $request->get('password'));
            if ($respons->code == 200) {
                $request->session()->put('user_information', $respons->body->data);
                return redirect('dashboard/profile');
            } else {
                return redirect(route('dash_manage_password'))->with('error', json_decode($respons->error)->meta->error_message);
            }
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector|void
     */
    public function logout(Request $request){
        $request->session()->flush();
        return redirect('/');
    }
}
