<?php

namespace App\Http\Controllers\Dashboard;

use App\General\Sms;
use App\Model\ProductsStore;
use App\Model\Transaction;
use App\Traits\Date;
use App\Traits\Gateway;
use App\Traits\Oauth;
use App\Traits\Shop;
use App\Traits\Wallet;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use App\Traits\License;
use Validator;

class LicenseController extends Controller
{
    use License;
    use Shop;
    use Date;

    public function __construct()
    {

    }

    public function licenses(Request $request)
    {
        $language = App::getLocale();
        $page_title = __('dashboard.My licenses');
        $licenses = License::myLicense($request);
        return view('dashboard.license.licenses', compact('page_title', 'language', 'licenses'));
    }

    public function license($key)
    {
        $language = App::getLocale();
        $page_title = __('dashboard.License information');
        $license = License::licenseInfoUser($key)->body->data;
        return view('dashboard.license.license', compact('page_title', 'language', 'license'));
    }

    public function activation($key)
    {
        $language = App::getLocale();
        $page_title = 'فعال سازی';
        return view('dashboard.license.activation', compact('page_title', 'language', 'key'));
    }

    public function activation_with_domain($key)
    {
        $language = App::getLocale();
        $page_title = __('dashboard.I have a domain');
        $response = License::licenseInfoUser($key);
        if ($response->code >= 200 && $response->code < 300) {
            $license = $response->body->data;
            return view('dashboard.license.with_domain', compact('page_title', 'language', 'license'));
        } else {
            return view('dashboard.license.with_domain', compact('page_title', 'language'))->with('error', 'error');
        }
    }

    public function activation_without_domain($key)
    {
        $language = App::getLocale();
        $page_title = __('dashboard.I have no domain');
        $response = License::licenseInfoUser($key);
        if ($response->code >= 200 && $response->code < 300) {
            $license = $response->body->data;
            return view('dashboard.license.without_domain', compact('page_title', 'language', 'license'));
        } else {
            return view('dashboard.shop.index', compact('page_title', 'language'))->with('error', 'error');
        }
    }

    public function reg_license(Request $request)
    {
        $prefix = $request->prefix;
        $suffix = $request->suffix;
        $domain = $prefix . '.' . $suffix;
        $code = $request->code;
        if (preg_match('/^(?!:\/\/)(?=.{1,255}$)((.{1,63}\.){1,127}(?![0-9]*$)[a-z0-9-]+\.?)$/i', $domain)) {
            $query = ['domain' => $prefix, 'suffix_domain' => $suffix];
            $exist = count(License::allLicense($query)->body->data);
            if ($exist > 0) {
                return redirect()->back();
            } else {
                $license = License::licenseInfoUser($code);
                if ($license->code >= 200 && $license->code < 300) {
                    $license = $license->body->data;
                    $expire_date = strtotime('+1 years', time()) * 1000;
                    $res_lic = License::updateLicenseUser($code, $prefix, $license->private_balance, $license->halfprivate_balance, $license->public_balance, $license->sms_balance, 1, $expire_date, $suffix);
                    if ($res_lic->code >= 200 && $res_lic->code < 300) {
                        $user_info = session()->get('user_information');
                        $domain = strtolower($prefix . '.' . $suffix);
                        $dashboard = $domain . '/login';
                        $password = rand(11111, 99999);
                        $mobile = $user_info->mobile_number;
                        $email = $user_info->email;
                        $res = License::create_host($mobile, $domain, $code, 'fa', 'فارسی', 'tem_workshop', $email, $password);
                        if ($res->body < 0) {
                            $this->_sendSmsError($mobile);
                        } else {
                            $this->_sendSmsAccept($mobile, $domain, $dashboard, $password);
                        }
                        return redirect(route('dash_license', $code));
                    } else {
                        return redirect()->back();
                    }
                }
            }
        } else {
            return redirect()->back();
        }
    }

    public function credit()
    {
        $language = App::getLocale();
        $page_title = 'اعتبار ایجاد دوره';
        return view('dashboard.license.credit', compact('page_title', 'language'));
    }

    public function credit_assign()
    {
        $language = App::getLocale();
        $page_title = 'سامانه های من';
        return view('dashboard.license.credit_assign', compact('page_title', 'language'));
    }

    public function credit_assign_form($key)
    {
        $language = App::getLocale();
        $page_title = 'اختصاص اعتبار ایجاد دوره';
        $response = License::licenseInfoUser($key);
        Shop::parse_product_json();
        $pr = ProductsStore::where('type', 'product')->get();
        $product = [];
        foreach ($pr as $value) {
            $product[$value->code]['pid'] = $value->pid;
            $product[$value->code]['name'] = $value->name;
            $product[$value->code]['code'] = $value->code;
            $product[$value->code]['type'] = $value->type;
            $product[$value->code]['price'] = $value->price;
            $product[$value->code]['tax'] = $value->tax;
        }
        $public_price = intval($product[config('global.SKU_PUBCREDIT_PR')]['price']);
        $private_price = intval($product[config('global.SKU_PRICREDIT_PR')]['price']);
        $hprivate_price = intval($product[config('global.SKU_HAFPRICREDIT_PR')]['price']);
        if ($response->code >= 200 && $response->code < 300) {
            $basket = Shop::basket('IRR');
            session()->put('basket_token_credit', $basket->body->meta->csrf->value);
            $license = $response->body->data;
            return view('dashboard.license.credit_assign_form', compact('page_title', 'language', 'license', 'key', 'public_price', 'private_price', 'hprivate_price'));
        } else {
            return view('dashboard.shop.index', compact('page_title', 'language'))->with('error', 'error');
        }
    }

    public function add_credit_basket(Request $request)
    {
        $token = $request->session()->get('basket_token_credit');
        $pr = ProductsStore::all();
        $product = [];
        foreach ($pr as $value) {
            $product[$value->code] = $value->pid;
        }
        $custom[$product[config('global.SKU_LICENSE')]] = $request->key;
        if ($request->public > 0) {
            Shop::add_to_basket($token, $product[config('global.SKU_PUBCREDIT_PR')], $request->public, 'IRR', null, $custom);
        }
        if ($request->private > 0) {
            Shop::add_to_basket($token, $product[config('global.SKU_PRICREDIT_PR')], $request->private, 'IRR', null, $custom);
        }
        if ($request->half_private > 0) {
            Shop::add_to_basket($token, $product[config('global.SKU_HAFPRICREDIT_PR')], $request->half_private, 'IRR', null, $custom);
        }
        return redirect(route('dash_credit_assigning'));
    }

    public function credit_assigning(Request $request)
    {
        $language = App::getLocale();
        $page_title = 'تکمیل سفارش';
        $token = $request->session()->get('basket_token_credit');
        $mobile = session()->get('user_information')->mobile_number;
        Shop::add_address($mobile , $token);
        $user_id    = session()->get('user_information')->id;
        $user_info = Oauth::userInformation($user_id);
        if (count(Wallet::balance($user_id)->body->data->wallet) == 0) {
            $wallet = 0;
        } else {
            $wallet = collect(Wallet::balance($user_id)->body->data->wallet)->where('currency_id', 'IRR')->first()->wallet;
        }
        $wallet = intval($wallet);
        $basket = Shop::basket('IRR', $token);
        $details = $basket->body->included[0]->attributes->attribute;
        $config = [];
        foreach ($details as $val) {
            $val = array_dot($val);
            $config[$val['order.base.product.attribute.code']] = $val;
        }
        $basket_info = array_dot($basket->body->data->attributes);
        $included = $basket->body->included;
        $public_price = $private_price = $hprivate_price = 0;
        foreach ($included as $value) {
            if ($value->type == 'basket/product') {
                if (array_dot($value->attributes)['order.base.product.prodcode'] == config('global.SKU_PUBCREDIT_PR')) {
                    $public_num = array_dot($value->attributes)['order.base.product.quantity'];
                    $public_price = array_dot($value->attributes)['order.base.product.price'] * array_dot($value->attributes)['order.base.product.quantity'];
                }
                if (array_dot($value->attributes)['order.base.product.prodcode'] == config('global.SKU_PRICREDIT_PR')) {
                    $private_num = array_dot($value->attributes)['order.base.product.quantity'];
                    $private_price = array_dot($value->attributes)['order.base.product.price'] * array_dot($value->attributes)['order.base.product.quantity'];
                }
                if (array_dot($value->attributes)['order.base.product.prodcode'] == config('global.SKU_HAFPRICREDIT_PR')) {
                    $hprivate_num = array_dot($value->attributes)['order.base.product.quantity'];
                    $hprivate_price = array_dot($value->attributes)['order.base.product.price'] * array_dot($value->attributes)['order.base.product.quantity'];
                }
            }
        }
        $quantity = array_dot($basket->body->included[0]->attributes)['order.base.product.quantity'];
        $amount_discount = 0;
        $amount = number_format(floor($basket_info['order.base.price']));
        $tax = number_format(floor($basket_info['order.base.taxvalue']));
        $pay = intval($basket_info['order.base.price']) + intval($basket_info['order.base.taxvalue']);
        $payable = number_format($pay);
        $last_product = array_dot(collect($basket->body->included)->where('type', 'basket/product')->last()->attributes)['order.base.product.price'];
        if (intval($last_product) < 0) {
            $amount_discount = abs(intval($last_product));
        }
        $pay = $pay - $wallet - $amount_discount;
        $amount_discount = number_format($amount_discount);
        $wallet = number_format($wallet);
        if ($pay < 0) {
            $pay = 0;
        }
        $pay = number_format($pay);
        if ($request->session()->has('discount')) {
            $discount = $request->session()->get('discount');
            if ($request->session()->get('discount')[0] == 1) {
                $request->session()->put('discount_status', $discount);
                $status = 1;
            } else {
                $status = 0;
            }
            $request->session()->forget('discount');
        } else {
            $status = -1;
            $discount = [-1];
        }
        return view('dashboard.license.credit_assign', compact('page_title', 'language', 'basket_info', 'amount', 'config', 'discount', 'status', 'tax', 'payable', 'user_info', 'wallet', 'pay', 'quantity', 'amount_discount', 'public_price', 'private_price', 'hprivate_price', 'public_num', 'private_num', 'hprivate_num'));
    }

    public function credit_discount(Request $request)
    {
        $token = $request->session()->get('basket_token_credit');
        $user_token = session()->get('user_token');
        $discount = Shop::discount( $user_token ,'IRR', $token, $request->discount);
        if ($discount->code >= 200 && $discount->code < 300) {
            $status = 1;
            $array = explode('/', $discount->header[0]);
            $dis = [$status, $array[0], $array[1]];
            $request->session()->put('discount', $dis);
        } else {
            $dis = [0, 0, 0];
            $request->session()->put('discount', $dis);
        }
        return redirect()->back();
    }

    public function credit_discount_delete(Request $request, $id)
    {
        $token = $request->session()->get('basket_token_credit');
        Shop::delete_discount('IRR', $token, $id);
        $request->session()->forget('discount_status');
        return redirect()->back();
    }

    public function credit_save_basket(Request $request)
    {
        $token = $request->session()->get('basket_token_credit');
        $basket = Shop::basket('IRR', $token);
        $basket_info = array_dot($basket->body->data->attributes);
        $payable = $basket_info['order.base.price'] + $basket_info['order.base.taxvalue'];
        $user_id    = session()->get('user_information')->id;
        if (count(Wallet::balance($user_id)->body->data->wallet) == 0) {
            $wallet = 0;
        } else {
            $wallet = collect(Wallet::balance($user_id)->body->data->wallet)->where('currency_id', 'IRR')->first()->wallet;
        }
        $diff = intval($payable) - intval($wallet);
        if ($diff > 0) {
            $request->session()->put('gateway_target', 'dash_pay_credit');
            if ($diff < 1000) {
                $amount = 1000;
            } else {
                $amount = $diff;
            }
            $invoiceID = uniqid(mt_rand(0, 999999), false);
            $transaction = new Transaction();
            $transaction->user_id = session()->get('user_information')->id;
            $transaction->amount = $amount;
            $transaction->invoiceID = $invoiceID;
            $terminalID = config('global.TerminalID');
            if ($transaction->save()) {
                $response = Gateway::getAccessToken($terminalID, $invoiceID, $amount, route('payment_callback'));
            }
            if (!$response['status']) {
                $accessToken = $response['Accesstoken'];
                return view('dashboard.payment.payment', compact('accessToken', 'terminalID'));
            } else {
                return redirect()->back()->with('respmsg', 'عملیات با خطا مواجه شد.');
            }
        } else {
            $user_token = session()->get('user_token');
            $result = Shop::basket_save($user_token , 'IRR', $token);
            if ($result->code >= 200 && $result->code < 300) {
                $order = Shop::create_invoice($user_token ,'IRR', $token, $result->body->data->id);
                if ($order->code >= 200 && $order->code < 300) {
                    $request->session()->forget('discount_status');
                    return redirect(route('dash_license', $order->header));
                } else {
                    return redirect()->back()->with('message', 'پرداخت صورتحساب با خطا مواجه شد.');
                }
            } else {
                return redirect()->back()->with('message', 'ایجاد صورتحساب با خطا مواجه شد.');
            }
        }
    }

    public function pay_credit(Request $request)
    {
        if (session()->get('status') == 1) {
            $token = $request->session()->get('basket_token_credit');
            $user_token = session()->get('user_token');
            $result = Shop::basket_save($user_token ,'IRR', $token);
            if ($result->code >= 200 && $result->code < 300) {
                $order = Shop::create_invoice($user_token ,'IRR', $token, $result->body->data->id);
                if ($order->code >= 200 && $order->code < 300) {
                    $request->session()->forget('discount_status');
                    return redirect(route('dash_license', $order->header));
                } else {
                    return redirect(route('dash_credit_assigning'))->with('message', 'پرداخت صورتحساب با خطا مواجه شد.');
                }
            } else {
                return redirect(route('dash_credit_assigning'))->with('message', 'ایجاد صورتحساب با خطا مواجه شد.');
            }
        } else {
            return redirect(route('dash_credit_assigning'))->with('message', session()->get('respmsg'));
        }
    }

    public function sms()
    {
        $language = App::getLocale();
        $page_title = 'اعتبار پیامکی';
        return view('dashboard.license.sms', compact('page_title', 'language'));
    }

    public function sms_assign()
    {
        $language = App::getLocale();
        $page_title = 'سامانه های من';
        return view('dashboard.license.sms_assign', compact('page_title', 'language'));
    }

    public function sms_assign_form($key)
    {
        $language = App::getLocale();
        $page_title = 'اختصاص اعتبار پیامکی';
        $response = License::licenseInfoUser($key);
        if ($response->code >= 200 && $response->code < 300) {
            Shop::parse_product_json();
            $price = ProductsStore::where('code', config('global.SKU_SMS'))->first()->price;
            $price = intval($price);
            $default_price = number_format($price * 500);
            $basket = Shop::basket('IRR');
            session()->put('basket_token_sms', $basket->body->meta->csrf->value);
            $license = $response->body->data;
            return view('dashboard.license.sms_assign_form', compact('page_title', 'language', 'license', 'price', 'default_price'));
        } else {
            return view('dashboard.shop.index', compact('page_title', 'language'))->with('error', 'error');
        }
    }

    public function add_sms_basket(Request $request)
    {
        $token = $request->session()->get('basket_token_sms');
        $smsId = ProductsStore::where('code', config('global.SKU_SMS'))->first()->pid;
        $pid = ProductsStore::where('code', config('global.SKU_LICENSE'))->first()->pid;
        $custom[$pid] = $request->key;
        Shop::add_to_basket($token, $smsId, $request->sms, 'IRR', null, $custom);
        return redirect(route('dash_sms_assigning', $request->key));
    }

    public function sms_assigning(Request $request)
    {
        $language = App::getLocale();
        $page_title = 'تکمیل سفارش';
        $token = $request->session()->get('basket_token_sms');
        $mobile = session()->get('user_information')->mobile_number;
        Shop::add_address($mobile , $token);
        $user_id    = session()->get('user_information')->id;
        $user_info = Oauth::userInformation($user_id);
        if (count(Wallet::balance($user_id)->body->data->wallet) == 0) {
            $wallet = 0;
        } else {
            $wallet = collect(Wallet::balance($user_id)->body->data->wallet)->where('currency_id', 'IRR')->first()->wallet;
        }
        $wallet = intval($wallet);
        $basket = Shop::basket('IRR', $token);
        $details = $basket->body->included[0]->attributes->attribute;
        $config = [];
        foreach ($details as $val) {
            $val = array_dot($val);
            $config[$val['order.base.product.attribute.code']] = $val;
        }
        $basket_info = array_dot($basket->body->data->attributes);
        $quantity = array_dot($basket->body->included[0]->attributes)['order.base.product.quantity'];
        $amount_discount = 0;
        $amount = number_format(floor($basket_info['order.base.price']));
        $tax = number_format(floor($basket_info['order.base.taxvalue']));
        $pay = intval($basket_info['order.base.price']) + intval($basket_info['order.base.taxvalue']);
        $payable = number_format($pay);
        $last_product = array_dot(collect($basket->body->included)->where('type', 'basket/product')->last()->attributes)['order.base.product.price'];
        if (intval($last_product) < 0) {
            $amount_discount = abs(intval($last_product));
        }
        $pay = $pay - $wallet - $amount_discount;
        $amount_discount = number_format($amount_discount);
        $wallet = number_format($wallet);
        if ($pay < 0) {
            $pay = 0;
        }
        $pay = number_format($pay);
        if ($request->session()->has('discount')) {
            $discount = $request->session()->get('discount');
            if ($request->session()->get('discount')[0] == 1) {
                $request->session()->put('discount_status', $discount);
                $status = 1;
            } else {
                $status = 0;
            }
            $request->session()->forget('discount');
        } else {
            $status = -1;
            $discount = [-1];
        }
        return view('dashboard.license.sms_assign', compact('page_title', 'language', 'basket_info', 'amount', 'config', 'discount', 'status', 'tax', 'payable', 'user_info', 'wallet', 'pay', 'quantity', 'amount_discount'));
    }

    public function sms_discount(Request $request)
    {
        $token = $request->session()->get('basket_token_sms');
        $user_token = session()->get('user_token');
        $discount = Shop::discount($user_token , 'IRR', $token, $request->discount);
        if ($discount->code >= 200 && $discount->code < 300) {
            $status = 1;
            $array = explode('/', $discount->header[0]);
            $dis = [$status, $array[0], $array[1]];
            $request->session()->put('discount', $dis);
        } else {
            $dis = [0, 0, 0];
            $request->session()->put('discount', $dis);
        }
        return redirect()->back();
    }

    public function sms_discount_delete(Request $request, $id)
    {
        $token = $request->session()->get('basket_token_sms');
        Shop::delete_discount('IRR', $token, $id);
        $request->session()->forget('discount_status');
        return redirect()->back();
    }

    public function sms_save_basket(Request $request)
    {
        $token = $request->session()->get('basket_token_sms');
        $basket = Shop::basket('IRR', $token);
        $basket_info = array_dot($basket->body->data->attributes);
        $payable = $basket_info['order.base.price'] + $basket_info['order.base.taxvalue'];
        $user_id    = session()->get('user_information')->id;
        if (count(Wallet::balance($user_id)->body->data->wallet) == 0) {
            $wallet = 0;
        } else {
            $wallet = collect(Wallet::balance($user_id)->body->data->wallet)->where('currency_id', 'IRR')->first()->wallet;
        }
        $diff = intval($payable) - intval($wallet);
        if ($diff > 0) {
            if ($diff < 1000) {
                $amount = 1000;
            } else {
                $amount = $diff;
            }
            $invoiceID = uniqid(mt_rand(0, 999999), false);
            $transaction = new Transaction();
            $transaction->user_id = session()->get('user_information')->id;
            $transaction->amount = $amount;
            $transaction->invoiceID = $invoiceID;
            $terminalID = config('global.TerminalID');
            if ($transaction->save()) {
                $response = Gateway::getAccessToken($terminalID, $invoiceID, $amount, route('payment_callback'));
            }
            if (!$response['status']) {
                $accessToken = $response['Accesstoken'];
                return view('dashboard.payment.payment', compact('accessToken', 'terminalID'));
            } else {
                return redirect()->back()->with('respmsg', 'عملیات با خطا مواجه شد.');
            }
        } else {
            $user_token = session()->get('user_token');
            $result = Shop::basket_save($user_token ,'IRR', $token);
            if ($result->code >= 200 && $result->code < 300) {
                $order = Shop::create_invoice($user_token ,'IRR', $token, $result->body->data->id);
                if ($order->code >= 200 && $order->code < 300) {
                    $request->session()->forget('discount_status');
                    return redirect(route('dash_license', $order->header));
                } else {
                    return redirect()->back()->with('message', 'پرداخت صورتحساب با خطا مواجه شد.');
                }
            } else {
                return redirect()->back()->with('message', 'ایجاد صورتحساب با خطا مواجه شد.');
            }
        }
    }

    public function pay_sms(Request $request)
    {
        if (session()->get('status') == 1) {
            $token = $request->session()->get('basket_token_credit');
            $user_token = session()->get('user_token');
            $result = Shop::basket_save(  $user_token ,'IRR', $token);
            if ($result->code >= 200 && $result->code < 300) {
                $order = Shop::create_invoice($user_token ,'IRR', $token, $result->body->data->id);
                if ($order->code >= 200 && $order->code < 300) {
                    $request->session()->forget('discount_status');
                    return redirect(route('dash_license', $order->header));
                } else {
                    return redirect(route('dash_sms_assigning'))->with('message', 'پرداخت صورتحساب با خطا مواجه شد.');
                }
            } else {
                return redirect(route('dash_sms_assigning'))->with('message', 'ایجاد صورتحساب با خطا مواجه شد.');
            }
        } else {
            return redirect(route('dash_sms_assigning'))->with('message', session()->get('respmsg'));
        }
    }

    public function check_domain(Request $request)
    {
        $suffix = strtolower($request->suffix);
        $name = strtolower($request->domain);
        $domain = $name . '.' . $suffix;
        $query = ['domain' => $domain];
        $exist = count(License::allLicense($query)->body->data);
        if ($name != '') {
            $validator = Validator::make($request->all(), [
                'domain' => [
                    'regex:/^[0-9A-Za-z -]+$/'
                ]
            ]);
            if ($exist == 0) {
                if ($validator->fails()) {
                    $status = 2;
                } else {
                    if (checkdnsrr($domain, 'ANY')) {
                        $status = 0;
                    } else {
                        $status = 1;
                    }
                }
            } else {
                $status = 0;
            }
        } else {
            $status = 3;
        }
        return response()->json(array('status' => $status, 'domain' => $domain));
    }

    public function validate_domain(Request $request)
    {
        $string = array('http://', 'https://');
        $request->domain = str_replace($string, '', $request->domain);
        $domain = strtolower($request->domain);
        $explode_domain = explode('.', $domain);
        $suffix = end($explode_domain);
        $ar_key = array_search($suffix, $explode_domain);
        unset($explode_domain[$ar_key]);
        $prefix = implode('.', $explode_domain);
        $query = ['domain' => $prefix, 'suffix_domain' => $suffix];
        $exist = count(License::allLicense($query)->body->data);
        if ($domain != '') {
            $validator = Validator::make($request->all(), [
                'domain' => [
                    'regex:/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/'
                ]
            ]);
            if ($exist == 0) {
                if ($validator->fails()) {
                    $status = 2;
                } else {
                    $status = 1;
                }
            } else {
                $status = 0;
            }
        } else {
            $status = 3;
        }
        return response()->json(array('status' => $status, 'domain' => $domain, 'prefix' => $prefix, 'suffix' => $suffix));
    }

    function _sendSmsError($number)
    {
        try {
            date_default_timezone_set("Asia/Tehran");
            // your   panel configuration
            $APIKey = 'b37c10284cda7476bbfe1028';
            $SecretKey = ']>*2Q"*.+Y8}q]hf';
            $data = array(
                'Mobile' => $number,
                'TemplateId' => 9661
            );
            $SmsIR_UltraFastSend = new Sms($APIKey, $SecretKey);
            $Result = $SmsIR_UltraFastSend->UltraFastSend($data);
            $status = $Result['VerificationCodeId'];
            if ($status != -1) {
                return true;
            } else {
                return false;
            }
        } catch (Exeption $e) {
            return false;
        }
    }

    function _sendSmsAccept($mobile, $domain, $dashboard, $password)
    {
        try {
            date_default_timezone_set("Asia/Tehran");
            // your   panel configuration
            $APIKey = 'b37c10284cda7476bbfe1028';
            $SecretKey = ']>*2Q"*.+Y8}q]hf';
            $data = array(
                'ParameterArray' => array(
                    array(
                        'Parameter' => 'domain',
                        'ParameterValue' => $domain
                    ),
                    array(
                        'Parameter' => 'dashboard',
                        'ParameterValue' => $dashboard
                    )
                ),
                'Mobile' => $mobile,
                'TemplateId' => 9660
            );
            $SmsIR_UltraFastSend = new Sms($APIKey, $SecretKey);
            $Result = $SmsIR_UltraFastSend->UltraFastSend($data);
            $status = $Result['VerificationCodeId'];
            if ($status != -1) {
                return true;
            } else {
                return false;
            }
        } catch (Exeption $e) {
            return false;
        }
    }

    public function checkLicense($code)
    {
        $license = License::checkLicense($code);
        return $license;
    }

    public function addResToLicense(Request $request)
    {
        $publicbalance = null;
        $privatebalance = null;
        $hprivatebalance = null;
        $smsbalance = null;
        switch ($request->type) {
            case "public":
                $publicbalance = $request->number;
                break;
            case "private":
                $privatebalance = $request->number;
                break;
            case "hprivate":
                $hprivatebalance = $request->number;
                break;
            case "sms":
                $smsbalance = $request->number;
                break;
        }
        $license = License::consumeLicense($request->code,$privatebalance,$hprivatebalance,$publicbalance,$smsbalance);
        if ($license->code >= 200 && $license->code < 300)
            return response()->json(['body' => ['data' => $license->body->data], 'error' => null, 'code' => 200])->setStatusCode(200);
        else
            return response()->json(['body' => null, 'error' => $license->error, 'code' => $license->code])->setStatusCode(500);
    }

    public function save_image(Request $request)
    {
            $file      = $request->input('file');
            $path      = $request->input('path');
            $image      = $request->input('image');
            if (!file_exists('media/images/domain/'.$path )) {
                mkdir('media/images/domain/'.$path , 0777 , true );
            }
            $this->downloadServer( $file , 'media/images/domain/'.$path.'/'.$image);

            if (file_exists('media/images/domain/'.$path.'/'.$image )) {
                echo 1;
            }else{
                echo 0;
            }
    }

    public function downloadServer( $url , $dir )
    {
        set_time_limit(0); // unlimited max execution time
        $ci = curl_init();
        $fp = fopen($dir , "w"); // Destination location
        curl_setopt_array( $ci, array(
            CURLOPT_URL => $url,
            CURLOPT_TIMEOUT => 3600,
            CURLOPT_FILE => $fp
        ));
        curl_exec($ci); // Returns '1' if successful
        curl_close($ci);
        fclose($fp);
    }
}
