<?php

namespace App\Http\Controllers\Dashboard;

use Illuminate\Contracts\Pagination\Paginator;
use App\Traits\Oauth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Pagination\LengthAwarePaginator;

class InvoiceController extends Controller
{
    public function __construct(){

    }
    public function invoices(Request $request){
        $id  = session()->get('user_information')->mobile_number;
        $language = App::getLocale();
        $queryString = $request->getQueryString();
        $invoices = Oauth::listInvoices($id , $queryString , $request);
        $page_title = 'صورتحسابها';
        return view('dashboard.invoice.invoices' , compact('page_title','invoices' , 'language'));
    }

    public function invoice($id){
        $mobile_number  = session()->get('user_information')->mobile_number;
        $language = App::getLocale();
        $invoice = Oauth::invoiceInformation($id)->data;
        if($invoice->user_mobilenumber == $mobile_number){
            $pricewithoutRebate = 0;
            foreach ($invoice->products as $product)
            {
                if ($product->product_code!= config('global.SKU_DISCOUNT') && $product->product_code!= config('global.SKU_DISCOUNT_YEKITA') && $product->product_code!= config('global.SKU_DISCOUNT_SMS') && $product->product_code!= config('global.SKU_DISCOUNT_CREDIT')) {
                    $pricewithoutRebate = $pricewithoutRebate + $product->price;
                }
            }
            $invoice->pricewithoutRebate = $pricewithoutRebate;

            $page_title = 'صورتحساب';
            return view('dashboard.invoice.invoice' , compact('page_title','invoice' , 'language'));
        }else{
            return redirect(route('dash_invoices'));
        }
    }
}
