<?php namespace App\Http\Controllers;

use App\Model\Course;
use App\Traits\License;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Str;

/**
 * Class CourseController
 * @package App\Http\Controllers
 */
class CourseController extends Controller
{
    /**
     * @param Request $request
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request){

        $group   = Lang::get('course_group');
        $lang    = App::getLocale();

        $conductors = DB::connection('mysql1')->table('conductor')
            ->select('conductor_key' , 'conductor')
            ->where('conductor', '!=' , null)
            ->where('lang', $lang)
            ->get();

        $db = DB::connection('mysql1')->table('courses');
        $db->join('course_attr', 'courses.course_key' , '=','course_attr.course_key');
        $db->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' );
        $db->select('courses.id' , 'courses.course_key' , 'courses.base_url' , 'courses.situation' , 'courses.date_start'  , 'courses.date_end' , 'courses.date_register' , 'courses.level' , 'courses.rate' , 'courses.capacity' , 'courses.image' , 'courses.cost_register as cost' , 'course_attr.title', 'course_attr.certificate_title' , 'course_attr.description' , 'course_attr.lang' , 'conductor.conductor');
        $db->where('courses.state' , 1);
        $db->where('course_attr.lang' , App::getLocale());
        $db->where('conductor.lang' , App::getLocale());
        $groups = array();
        if(isset($request->group)){
            $groups = explode( ',' , $request->group);
            foreach ($groups as $value){
                $db->where('courses.group' , 'like' , '%'.$value.'%');
            }
        }
        $conductors_s = array();
        if(isset($request->conductor)){
            $conductors_s = explode( ',' , $request->conductor);
            $db->where(function ($query) use ($conductors_s) {
                $query->where('courses.conductor_key', $conductors_s[0]);
                foreach ($conductors_s as $key => $value){
                    if($key != 0){
                        $query->orWhere('courses.conductor_key' , $value);
                    }
                }
            });
        }
        $amount = '50000-5000000';
        if(isset($request->amount)){
            $amount = $request->amount;
            $amo = explode('-' , $amount);
            $db->where('courses.cost_register' , '>=' , $amo[0]);
            $db->where('courses.cost_register' , '<=' , $amo[1]);
        }
        $search = '';
        if(isset($request->search)){
            $search = $request->search;
            $db->where(function ($query) use ($request) {
                $query->where('course_attr.title' , 'like' , '%'.$request->search.'%');
                    $query->orWhere('course_attr.certificate_title' , 'like' , '%'.$request->search.'%');
                    $query->orWhere('courses.course_key' , 'like' , '%'.$request->search.'%');
                    $query->orWhere('courses.base_url' , 'like' , '%'.$request->search.'%');
            });
        }
        $certificate = 'all';
        if(isset($request->certificate)){
            $certificate = $request->certificate;
            if($certificate != 'all'){
                $db->where('courses.certificate' , $certificate);
            }
        }
        if(isset($request->rate)){
            $rate = $request->rate;
            $db->where('courses.rate' , '>=' , $rate);
        }
        $course_type = 'all';
        if(isset($request->course_type)){
            if($request->course_type == 'active'){
                $course_type = 'active';
                $db->where('courses.situation' , 'active');
            }else{
                $course_type = 'all';
            }
        }
        $sort = 'new';
        if(isset($request->sort)){
            if($request->sort == 'new'){
                $sort = 'new';
                $db->orderBy('courses.id' , 'desc');
            }else{
                $sort = 'rate';
                $db->orderBy('courses.rate' , 'desc');
            }
        }else{
            $sort = 'new';
            $db->orderBy('courses.id' , 'desc');
        }
        $courses = $db->paginate(36);
        return view('front.courses' , compact('courses' , 'course_type' , 'group' , 'groups' , 'conductors' , 'conductors_s' , 'amount' , 'search' , 'certificate' , 'lang' , 'sort'));
    }

    /**
     * @param Request $request
     * @param $lang
     * @param $id
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function course(Request $request ,$lang , $id){
        //$group   = Lang::get('course_group');

        $lang    = App::getLocale();
        $course = DB::connection('mysql1')->table('courses')
            ->join('course_attr','courses.course_key' , '=','course_attr.course_key' )
            ->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' )
            ->select('courses.id', 'courses.course_key', 'courses.base_url', 'courses.group', 'courses.type', 'courses.level', 'courses.lat', 'courses.long', 'courses.situation', 'courses.date_start', 'courses.date_end', 'courses.date_register', 'courses.date_quiz', 'courses.level', 'courses.rate', 'courses.image', 'courses.cost_register as cost', 'course_attr.title', 'courses.certificate', 'course_attr.certificate_title', 'course_attr.lang', 'course_attr.description', 'conductor.conductor')
            ->where('course_attr.lang' , $lang)
            ->where('conductor.lang' , $lang)
            ->where('courses.id' , $id)
            ->get()[0];
        $participants = DB::connection('mysql1')->table('participants')->where('course_key' , $course->course_key)->count();
        $groups = json_decode($course->group);
        foreach ($groups as $key => $group){
            $groups[$key] =  __('course_group.'.$group);
        }
        $course->group = implode(' - ' , $groups);

        if($course->type == 'workshop'){
            $course->type = 'کارگاه آموزشی';
        }elseif ($course->type == 'course'){
            $course->type = 'دوره آموزشی';
        }elseif ($course->type == 'live'){
            $course->type = 'آموزش مجازی';
        }

        if($course->level == 'public'){
            $course->level = 'گروهی';
        }elseif ($course->level == 'private'){
            $course->level = 'خصوصی';
        }elseif ($course->level == 'half-private'){
            $course->level = 'نیمه گروهی';
        }

        $start = new Carbon($course->date_start);
        $end = new Carbon($course->date_end);
        $course->duration = ($start->diff($end)->days);

        $teachers = DB::connection('mysql1')->table('teacher')
            ->distinct()->select('teacher_attr.mobile' , 'teacher_attr.first_name' , 'teacher_attr.last_name' , 'teacher_attr.avatar')
            ->join('teacher_attr','teacher_attr.mobile' , '=','teacher.teacher' )
            ->where('teacher.course_key' , $course->course_key)
            ->where('teacher.state' , 1)
            ->where('teacher_attr.lang' , $lang)
            ->groupBy()
            ->get();

        $page_title   = Str::limit($course->title,53,'');
        $description   = Str::limit($course->description,148,'');
        return view('front.course' , compact('course' , 'teachers' , 'lang' , 'page_title','description'));

    }
}
