<?php namespace App\Http\Controllers;

use App\Model\ConductorModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

/**
 * Class ConductorController
 * @package App\Http\Controllers
 */
class ConductorController extends Controller
{
    /**
     * @param Request $request
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $lang = App::getLocale();
        $conductors = ConductorModel::Where('status', 'enable')->Where('display', 'show')->Where('logo', '!=', null)
            ->select('conductor', 'base_url', 'logo')->paginate(36);

        return view('front.conductors', compact('conductors', 'lang'));
    }
}
