<?php

namespace App\Http\Controllers;

use  App\Model\Comment;
use  App\Model\Blog;
use Illuminate\Support\Facades\App;
use Validator;
use Illuminate\Http\Request;

class CommentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $nice_input_names = ['fullname' => 'نام کامل','body' => 'نظر'];
        $validator = Validator::make($request->all(), ['fullname' => ['required'],'body' => ['required']],array(),$nice_input_names);

        if ($validator->fails()) {
            return redirect("/content/".$request->get('blog_id').'/'.App::getLocale().'/#comment')
                ->withErrors($validator)
                ->withInput();
        }

        $comment =  new Comment();
        $comment->fullname = $request->get('fullname');
        $comment->body = $request->get('body');
        $comment->status =1;
        $blog = blog::find($request->get('blog_id'));
        $blog->comment()->save($comment);
        return redirect()->back()->with('message' , 'نظر شما به این مطلب با موفقیت ارسال شد');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Comment  $comment
     * @return \Illuminate\Http\Response
     */
    public function show(Comment $comment)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Comment  $comment
     * @return \Illuminate\Http\Response
     */
    public function edit(Comment $comment)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Comment  $comment
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Comment $comment)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Comment  $comment
     * @return \Illuminate\Http\Response
     */
    public function destroy(Comment $comment)
    {
        //
    }
}
