<?php

namespace App\Http\Controllers;

use App\Model\Blog;
use App\Model\Comment;
use App\Model\BlogTranslate;
use App\Model\Visit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

class BlogController extends Controller
{
    public function index(){
        $lang    = App::getLocale();
        $page_title = 'بلاگ';
        $data = DB::table('blogs')
                ->join('blogs_translate','blogs_translate.blog_id' , '=','blogs.id' )
                ->orderBy('blogs.id' , 'desc')
                ->select('blogs.id', 'blogs_translate.title', 'blogs_translate.content' , 'blogs_translate.description'  , 'blogs_translate.created_at' ,'blogs_translate.visit' ,'blogs_translate.image','blogs_translate.slug')
                ->where('blogs.status' , 'active')
                ->where('blogs_translate.lang' , App::getLocale())
                ->paginate(24);
        return view('front.blogs' , compact('data' , 'lang' , 'page_title'));
    }
    public function blog(Request $request){
        $lang    = App::getLocale();
        $lang_show = $request->lang;
        if($lang_show == 'index.html'){
            $lang_show = 'fa';
        }
        $blogs = DB::table('blogs')
            ->join('blogs_translate','blogs_translate.blog_id' , '=','blogs.id' )
            ->select('blogs.id', 'blogs_translate.title', 'blogs_translate.content' , 'blogs_translate.description' , 'blogs_translate.created_at' ,'blogs_translate.visit' ,'blogs_translate.image')
            ->where('blogs.status' , 'active')
            ->where('blogs_translate.lang' , App::getLocale())
            ->paginate(2);
        $data = BlogTranslate::where('slug',$request->id)->where('lang' , $lang_show)->get()[0];
        $ip = $request->ip();
        $id = $data->id;
        $created_at = date('Y-m-d');
        $visit = Visit::where('blog_id' , $id)->where('ip' , $ip)->where('created_at' , 'like' , $created_at.'%')->get();
        if (count($visit) < 1){
            Visit::create([
                'blog_id' => $id,
                'ip' => $ip
            ]);
            $num_visit = intval($data->visit) + 1;
            $data->visit = $num_visit;
            $data->save();
        }
        $page_title = $data->title;

        $comments=Comment::all()
            ->where('blog_id',$request->id)
            ->where('status',1)
            ->sortByDesc('created_at');

        return view('front.blog' , compact('data', 'blogs' , 'lang' , 'page_title','comments'));
    }
}