<?php

namespace App\Http\Controllers;

use App\General\Sms;
use App\Model\Discount;
use App\Model\Product;
use App\Model\ProductsStore;
use App\Model\Transaction;
use App\Traits\Gateway;
use App\Traits\License;
use App\Traits\Oauth;
use App\Traits\Shop;
use App\Traits\Wallet;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class BasketController extends Controller
{
    use Shop;


    public function shop(Request $request)
    {
        if(!session()->has('platform_id')){
            return redirect()->route('home.1');
        }
        $page_title = 'خرید سامانه';
        $lang    = App::getLocale();

        $suffix = Product::where('type', 'دامنه')
            ->orderBy('price', 'asc')
            ->get();

        return view('front.shop' ,compact( 'lang' , 'page_title' , 'suffix'));
    }

    public function add_to_basket(Request $request)
    {
        $domain_prefix = $request->domain_prefix;
        $domain_suffix = $request->domain_suffix;
        $request->session()->forget('discount_status');
        $request->session()->forget('discount');
        $request->session()->forget('domain_setup');


        if (isset($domain_prefix) && $domain_prefix != '0') {
            session()->put('HASDOMAIN', false);
            session()->put('domain_setup', (object)['domain' => $domain_prefix, 'suffix' => $domain_suffix]);
            session()->put('domain_id', $request->domain_id);
        }
        elseif($request->has_domain){
            session()->put('domain_setup', (object)[
                'prefix' => $request->has_domain_prefix, 
                'domain' => $request->has_domain, 
                'suffix' => $request->has_domain_suffix
                ]);
            session()->put('HASDOMAIN', true);
        }else{
            $request->validate([
                'has_domain' => 'required|string'
            ],[
                'required' => 'فیلد دامنه ضروری است'
            ]);
        }


        $mobile = session()->get('user_information')->mobile_number;

        return redirect(route('home_basket_information'));
    }

    public function basket_information(Request $request)
    {
        if(!session()->has("platform_id")){
            return redirect()->route('home.1');
        }

        return view("front.information");
    }

    public function save_basket_information(Request $request)
    {  
        $request->validate([
            'license_email' => 'required|email',
        ],[
            'license_email.required' => 'فیلد ایمیل ضروری است.',
            'license_email.email' => 'ایمیل شما نا معتبر است.'
        ]);

        $data = (object)['nic_id' => $request->nic_id,'license_email' => $request->license_email];
        session(['license_information' => $data]);

        return redirect(route('home_basket'));
    }

    public function basket(Request $request)
    {           
        if(!session()->has("platform_id")){
            return redirect()->route('home.1');
        }
        $token = $request->session()->get('basket_token_front');
        $domain = '';
	    $suffix = ' ';
        if($request->session()->has('domain_setup')) {
            $suffix = session()->get('domain_setup')->suffix;
        }
        $lang    = App::getLocale();
        $page_title = 'سبد خرید';
        $user_id = session()->get('user_information')->id;

       /*  if(count(Wallet::balance($user_id)->body->data->wallet) == 0){
            $wallet = 0;
        }else{
            $wallet     = collect(Wallet::balance($user_id)->body->data->wallet)->where('currency_id' , 'IRR')->first()->wallet;
        }
        $wallet     = intval($wallet); */

        /* $basket = Shop::basket('IRR' , $token);
        $basket_info = array_dot($basket->body->data->attributes); */


        $platform = Product::find(session("platform_id"));
        $total_price = $platform->price;
        if(!session()->get('HASDOMAIN')){
            $domain = Product::find(session("domain_id"));
            $total_price += $domain->price;
        }
        $sms = Product::where([['type','sms'],['status','1']])->first();

        return view('front.basket' ,compact( 'lang' ,'platform','domain','total_price','sms', 'page_title','suffix'));
    }

    public function discount(Request $request)
    {
        $code = Discount::where('code',$request->discount_code)->whereDate('expire_at','>=',Carbon::now())->get();
 
        if(count($code) < 1){
            return -1;
        }else{
            return $code->first();
        }
    }

    public function discount_delete(Request $request , $id)
    {
        $token = $request->session()->get('basket_token_front');
        Shop::delete_discount('IRR' , $token , $id);
        $request->session()->forget('discount_status');

        return redirect(route('home_basket'));
    }

    public function save_basket(Request $request)
    {
        $request->validate([
            'rules' => 'required'
        ],[
            'rules.required' => 'قوانین و مقررات را تایید نمایید.'
        ]);

        $user_id    = session()->get('user_information')->id;
        $user_info   = User::find($user_id);
        $terminalID = config('global.TerminalID');
        $platform = Product::find(session('platform_id'));
        $amount = ($platform->price + (($platform->price * (int)$platform->tax)/100) );

        if(!session()->get('HASDOMAIN')){
            $domain = Product::find(session("domain_id"));
            $amount += $domain->price;
        }
        
        if($discount = Discount::where('code',$request->discount)->first()){
            $amount = $amount - (((int)$discount->percentage * $amount) / 100);
        }
        
        $platform = json_encode([
            'platform' => [
                'platform_id' => session("platform_id"),
                'platform_price' => $platform->price,
                'email' => session()->get('license_information')->license_email
            ],
            'discount' => $request->discount,
            'domain' => [
                'has_domain' =>  session()->get('HASDOMAIN'),
                'prefix' =>  isset(session('domain_setup')->prefix) ? session('domain_setup')->prefix : '',
                'domain' =>  session()->has('domain_setup') ? session('domain_setup')->domain : '',
                'suffix' =>  session()->has('domain_setup') ? session('domain_setup')->suffix : '',
                'nic_id' => session()->get('license_information')->nic_id
            ]
        ]);

        $request->session()->put('gateway_target' , 'home_pay_basket');
        $invoiceID = uniqid(mt_rand(0, 999999), false);
        $transaction = new Transaction();
        $transaction->user_id = session()->get('user_information')->id;
        $transaction->amount = $amount;
        $transaction->invoiceID = $invoiceID;
        $transaction->platform = $platform;
        
        if ($transaction->save()){

            if($request->gateway == 1){
                $response = Gateway::getAccessToken($terminalID, $invoiceID, $amount, route('payment_callback'));
                if (!$response['status']) {
                    $accessToken = $response['Accesstoken'];
                    return view('dashboard.payment.payment', compact('accessToken', 'terminalID'));
                }else{
                    return redirect()->back()->with('message' , 'عملیات با خطا مواجه شد.');
                } 
            }
            
            if($request->gateway == 2){
                $result = Gateway::zarinpal($amount);
                if($result->Status == 100){
                    $transaction->documentـnumber = $result->Authority;
                    $transaction->update();
                    return redirect()->to('https://sandbox.zarinpal.com/pg/StartPay/'.$result->Authority);
                }
            }
        }
     
    }

    public function checking_rules(Request $request)
    {
        $status = strtolower($request->status);
        if($status == 1){
            $request->session()->put('checking_rules' , true);
        }else{
            $request->session()->put('checking_rules' , false);
        }
        return response()->json(array('status' => $status));
    }

    public function pay_basket(Request $request)
    {
        if(session()->get('status') == 1){
            $token       = $request->session()->get('basket_token_front');
            $user_token  = session()->get('user_token');
            $result = Shop::basket_save( $user_token ,'IRR' , $token);
            if ($result->code >= 200 && $result->code < 300){
                $order = Shop::create_invoice($user_token ,'IRR' , $token , $result->body->data->id);
                if ($order->code >= 200 && $order->code < 300){
                    $request->session()->forget('discount_status');
                    if(session()->get('HASDOMAIN')){
                        $user_info   = session()->get('user_information');
                        $this->_sendSmsSupportWithoutDomain('09194904117' , $user_info->mobile_number , $order->header);
                        $this->_sendSmsSupportWithoutDomain('09114676046' , $user_info->mobile_number , $order->header);
                        return redirect(route('dash_activation_with_domain' , $order->header));
                    }else{
                        $user_info   = session()->get('user_information');
                        $domain      = strtolower(session()->get('domain_setup'));
                        $dashboard   = $domain.'/login';
                        $password    = rand(11111 , 99999);
                        $res = License::create_host( $user_info->mobile_number , $domain , $order->header , 'fa' , 'فارسی' , 'tem_workshop' , $user_info->email , $password);
                        if($res->body < 0){
                            $this->_sendSmsError($user_info->mobile_number);
                        }else{
                            $this->_sendSmsAccept($user_info->mobile_number , $domain , $dashboard , $password);
                            $this->_sendSmsSupportWithDomain('09194904117' , $domain , $user_info->mobile_number , $order->header);
                            $this->_sendSmsSupportWithDomain('09114676046' , $domain , $user_info->mobile_number , $order->header);
                        }
                        return redirect(route('dash_license' , $order->header));
                    }
                }else{
                    return redirect(route(''))->with('message' , 'پرداخت صورتحساب با خطا مواجه شد.');
                }
            }else{
                return redirect(route('home_basket'))->with('message' , 'ایجاد صورتحساب با خطا مواجه شد.');
            }
        }else{
            return redirect(route('home_basket'))->with('message' , session()->get('respmsg'));
        }
    }

    function _sendSmsError($number)
    {
        try {
            date_default_timezone_set("Asia/Tehran");
            // your   panel configuration
            $APIKey = 'b37c10284cda7476bbfe1028';
            $SecretKey = ']>*2Q"*.+Y8}q]hf';
            $data = array(
                'Mobile' => $number,
                'TemplateId' => 9661
            );
            $SmsIR_UltraFastSend = new Sms($APIKey,$SecretKey);
            $Result = $SmsIR_UltraFastSend->UltraFastSend($data);
            $status = $Result['VerificationCodeId'];
            if($status != -1){
                return true;
            }else{
                return false;
            }
        } catch (Exeption $e) {
            return false;
        }
    }
    function _sendSmsAccept($mobile , $domain , $dashboard , $password)
    {
        try {
            date_default_timezone_set("Asia/Tehran");
            // your   panel configuration
            $APIKey = 'b37c10284cda7476bbfe1028';
            $SecretKey = ']>*2Q"*.+Y8}q]hf';
            $data = array(
                'ParameterArray' => array(
                    array(
                        'Parameter' => 'domain',
                        'ParameterValue' => $domain
                    ),
                    array(
                        'Parameter' => 'dashboard',
                        'ParameterValue' => $dashboard
                    ),
                    array(
                        'Parameter' => 'mobile',
                        'ParameterValue' => $mobile
                    ),
                    array(
                        'Parameter' => 'password',
                        'ParameterValue' => $password
                    )
                ),
                'Mobile' => $mobile,
                'TemplateId' => 9659
            );
            $SmsIR_UltraFastSend = new Sms($APIKey,$SecretKey);
            $Result = $SmsIR_UltraFastSend->UltraFastSend($data);
            $status = $Result['VerificationCodeId'];
            if($status != -1){
                return true;
            }else{
                return false;
            }
        } catch (Exeption $e) {
            return false;
        }
    }
    function _sendSmsSupportWithDomain($number , $domain , $mobile , $license)
    {
        try {
            date_default_timezone_set("Asia/Tehran");
            // your   panel configuration
            $APIKey = 'b37c10284cda7476bbfe1028';
            $SecretKey = ']>*2Q"*.+Y8}q]hf';
            $data = array(
                'ParameterArray' => array(
                    array(
                        'Parameter' => 'domain',
                        'ParameterValue' => $domain
                    ),
                    array(
                        'Parameter' => 'mobile',
                        'ParameterValue' => $mobile
                    ),
                    array(
                        'Parameter' => 'license',
                        'ParameterValue' => $license
                    )
                ),
                'Mobile' => $number,
                'TemplateId' => 4809
            );
            $SmsIR_UltraFastSend = new Sms($APIKey,$SecretKey);
            $Result = $SmsIR_UltraFastSend->UltraFastSend($data);
            $status = $Result['VerificationCodeId'];
            if($status != -1){
                return true;
            }else{
                return false;
            }
        } catch (Exeption $e) {
            return false;
        }
    }
    function _sendSmsSupportWithoutDomain($number , $mobile , $license)
    {
        try {
            date_default_timezone_set("Asia/Tehran");
            // your   panel configuration
            $APIKey = 'b37c10284cda7476bbfe1028';
            $SecretKey = ']>*2Q"*.+Y8}q]hf';
            $data = array(
                'ParameterArray' => array(
                    array(
                        'Parameter' => 'mobile',
                        'ParameterValue' => $mobile
                    ),
                    array(
                        'Parameter' => 'license',
                        'ParameterValue' => $license
                    )
                ),
                'Mobile' => $number,
                'TemplateId' => 4810
            );
            $SmsIR_UltraFastSend = new Sms($APIKey,$SecretKey);
            $Result = $SmsIR_UltraFastSend->UltraFastSend($data);
            $status = $Result['VerificationCodeId'];
            if($status != -1){
                return true;
            }else{
                return false;
            }
        } catch (Exeption $e) {
            return false;
        }
    }

    public function buy_plan(Request $request){
        if(!$request->platform_id){
            return redirect()->back();
        }
        session()->put('platform_id',$request->platform_id);
        return redirect()->route('home_shop',App::getLocale());
    }
}
