<?php

namespace App\Http\Controllers\Api;

use App\Traits\Oauth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class UserController extends Controller
{
    public function save_document(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'file' => 'required',
            'user_id' => 'required'
        ]);
        $result = Oauth::save_document($request->title , $request->file , $request->user_id);
        return response()->json($result);
    }

    public function delete_document(Request $request)
    {
        $request->validate([
            'file_id' => 'required',
            'user_id' => 'required'
        ]);
        $result = Oauth::delete_document($request->file_id , $request->user_id);
        return response()->json($result);
    }

    public function get_document($id)
    {
        $result = Oauth::get_document($id);
        return response()->json($result);
    }
}
