<?php

namespace App\Http\Controllers\Api;

use App\Model\TeacherAttrModel;
use App\Traits\Oauth;
use http\Client\Curl\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TeacherController extends Controller
{
    public function check_teacher($mobile)
    {
        $teacher['data'] = TeacherAttrModel::where('mobile' , $mobile)->get();
        if(count($teacher['data']) < 1){
            $response = Oauth::getUserToken($mobile);
            $gender = 'mr';
            if($response->body->data->user->gender == 'female'){
                $gender = 'ms';
            }
            $teacher = array(
                    "id" => $response->body->data->user->id,
                    "sex"=> $gender,
                    "mobile"=> $mobile,
                    "title"=> "",
                    "first_name"=> $response->body->data->user->name,
                    "last_name"=> $response->body->data->user->lastname,
                    "full_name"=> $response->body->data->user->name.' '.$response->body->data->user->lastname,
                    "avatar"=> $response->body->data->user->avatar,
                    "popular"=> 0,
                    "rate"=> 0,
                    "view_information"=> 1,
                    "status"=> "enable",
                    "display"=> "show",
                    "isCompleted"=> $response->body->data->user->isCompleted
            );
            $teacher['status_teacher'] = false;
        }else{
            $teacher['status_teacher'] = true;
        }
        return response()->json($teacher);
    }

    public function add_teacher(Request $request)
    {
        $teachers = json_decode($request->getContent());
        $array = json_decode(json_encode($teachers), True);
        foreach ($array as $teacher){
            TeacherAttrModel::create($teacher);
        }
        return response()->json(array(
            'code' => 200
        ));
    }

    public function add_teacher_form(Request $request)
    {
        $teacher = json_decode($request->getContent());
        $array = json_decode(json_encode($teacher), True);
        $gender = 'male';
        if($array['sex'] == 'ms'){
            $gender = 'female';
        }
        $user = Oauth::updateUser($array['user_id'], $array['avatar'], $array['first_name'], $array['last_name'], $gender);
       
        TeacherAttrModel::create($array);
        return response()->json(array(
            'code' => 200
        ));
    }

    public function add_teacher_attr(Request $request)
    {
        $teachers = json_decode($request->getContent());
        $array = json_decode(json_encode($teachers), True);
        $response = Oauth::getUserToken($array['mobile']);
        TeacherAttrModel::where('mobile' , $array['mobile'])->update(['avatar' => $response->body->data->user->avatar]);
        $teacher_attr = TeacherAttrModel::where('mobile' , $array['mobile'])->where('lang' , $array['lang'])->first();
        if(is_null($teacher_attr)){
            TeacherAttrModel::create([
                'sex' => $array['sex'],
                'mobile' => $array['mobile'],
                'title' => $array['title'],
                'first_name' => $array['first_name'],
                'last_name' => $array['last_name'],
                'full_name' => $array['first_name'].' '.$array['last_name'],
                'avatar' => $response->body->data->user->avatar,
                'view_information' => $array['view_information'],
                'telegram' => $array['telegram'],
                'instagram' => $array['instagram'],
                'facebook' => $array['facebook'],
                'linkedin' => $array['linkedin'],
                'pinterest' => $array['pinterest'],
                'youtube' => $array['youtube'],
                'aparat' => $array['aparat'],
                'lang' => $array['lang']
            ]);
        }else{
            $teacher_attr->first_name = $array['first_name'];
            $teacher_attr->last_name = $array['last_name'];
            $teacher_attr->full_name = $array['first_name'].' '.$array['last_name'];
            $teacher_attr->title = $array['title'];
            $teacher_attr->save();
        }
        return response()->json(array(
            'code' => 200
        ));
    }
}
