<?php

namespace App\Http\Controllers\Api;

use App\Model\Course;
use App\Model\ParticipantsModel;
use App\Model\TeacherAttrModel;
use App\Traits\Oauth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class RecommenderController extends Controller
{
    public function users(Request $request)
    {
        return Oauth::listUser_api($request);
    }

    public function users_today(Request $request)
    {
        return Oauth::todayUser($request);
    }

    public function courses(Request $request)
    {
        return Course::paginate(500);
    }

    public function courses_today(Request $request)
    {
        return Course::whereDate('create_date', Carbon::today())->paginate(500);
    }

    public function participants(Request $request)
    {
        return ParticipantsModel::paginate(500);
    }

    public function participants_today(Request $request)
    {
        return ParticipantsModel::whereDate('date', Carbon::today())->paginate(500);
    }

    public function teachers(Request $request)
    {
        return TeacherAttrModel::paginate(500);
    }
}
