<?php

namespace App\Http\Controllers\Api;

use App\Model\PamphletsModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class PamphletsController extends Controller
{
    public function add_pamphlet(Request $request)
    {
        $file       =   file_get_contents($request->source);
        $key        =   $request->key;
        $created    =   Storage::disk('minio')->put($key , $file);
        if($created){
             $pamphlet = PamphletsModel::create([
                'title' => $request->title,
                'description' => $request->description,
                'course_key' => $request->course_key,
                'license' => $request->license,
                'file' => $request->key,
                'size' => $request->size,
                'type' => $request->type,
                'show' => $request->show
            ]);
            $response = array(
                'status' => true,
                'id' => $pamphlet->id
            );
        }else{
            $response = array(
                'status' => false
            );
        }
        return response()->json($response);
    }
    public function edit_pamphlet(Request $request , $id)
    {
        $pamphlet = PamphletsModel::find($id);
        $pamphlet->title = $request->title;
        $pamphlet->description = $request->description;
        $pamphlet->save();
        return response()->json($pamphlet);
    }
    public function edit_upload_pamphlet(Request $request , $id)
    {
        $pamphlet = PamphletsModel::find($id);
        $file       =   file_get_contents($request->source);
        $key        =   $request->key;
        Storage::disk('minio')->put($key , $file);
        $pamphlet->file = $request->key;
        $pamphlet->size = $request->size;
        $pamphlet->type = $request->type;
        $pamphlet->title = $request->title;
        $pamphlet->description = $request->description;
        $pamphlet->save();
        return response()->json($pamphlet);
    }
    public function remove_pamphlet(Request $request , $id)
    {
        $pamphlet = PamphletsModel::find($id);
        if($pamphlet->license == $request->license && $pamphlet->course_key == $request->course_key){
            $pamphlet->delete();
            $response = array(
                'status' => true
            );
        }else{
            $response = array(
                'status' => false
            );
        }
        return response()->json($response);
    }

    public function change_show_pamphlets(Request $request)
    {
        PamphletsModel::where('license' , $request->license)->where('course_key' , $request->course_key)->update(array('show' => $request->status));
        $response = array(
            'status' => true
        );
        return response()->json($response);
    }
}
