<?php

namespace App\Http\Controllers\Api;

use App\Model\LiveMeeting;
use App\Traits\Live;
use App\Traits\Oauth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Orchestra\Parser\Xml\Facade as XmlParser;

class LiveController extends Controller
{
    public function create_room(Request $request)
    {
        $name       = $request->name;
        $meetingID  = $request->meetingID;
        $duration   = $request->duration;
        $welcome    = $request->welcome;
        $logo       = $request->logo;
        $logout     = $request->logout;
        $message_status    = $request->message_status;
        $webcam_status     = $request->webcam_status;

        $bannerText = $request->bannerText;
        $copyright  = $request->copyright;
        $maxParticipants  = $request->maxParticipants;
        $live_exist = LiveMeeting::where('meetingID' , $meetingID)->get();
        if(count($live_exist) < 1){
            $response = Live::create($name , $meetingID , $duration , $welcome , $logo , $maxParticipants , $bannerText , $copyright , $logout , $message_status , $webcam_status);
            $xml = XmlParser::extract('<api>'.$response.'</api>');
            $met = $xml->parse([
                'returncode' => ['uses' => 'response.returncode']
            ]);
            if($met['returncode'] == 'SUCCESS'){
                $meeting = $xml->parse([
                    'meetingID' => ['uses' => 'response.meetingID'],
                    'internalMeetingID' => ['uses' => 'response.internalMeetingID'],
                    'parentMeetingID' => ['uses' => 'response.parentMeetingID'],
                    'attendeePW' => ['uses' => 'response.attendeePW'],
                    'moderatorPW' => ['uses' => 'response.moderatorPW'],
                    'createTime' => ['uses' => 'response.createTime'],
                    'voiceBridge' => ['uses' => 'response.voiceBridge'],
                    'dialNumber' => ['uses' => 'response.dialNumber'],
                    'createDate' => ['uses' => 'response.createDate'],
                    'hasUserJoined' => ['uses' => 'response.hasUserJoined'],
                    'duration' => ['uses' => 'response.duration'],
                    'hasBeenForciblyEnded' => ['uses' => 'response.hasBeenForciblyEnded'],
                    'messageKey' => ['uses' => 'response.messageKey'],
                    'message' => ['uses' => 'response.message']
                ]);

                LiveMeeting::create($meeting);

                $res = array(
                    'error' => null,
                    'message' => 'success',
                    'body' => $meeting
                );

            }else{
                dd($response);
                $res = array(
                    'error' => 'failed',
                    'message' => 'Room not created',
                    'body' => null
                );
            }
        }else{
            $res = array(
                'error' => 'failed',
                'message' => 'There is a meetingID',
                'body' => null
            );
        }
        return response()->json($res);
    }

    public function join_room_teacher(Request $request)
    {
        $id         = $request->id;
        $meetingID  = $request->meetingID;
        $Html5      = $request->Html5;
        $user       = Oauth::userInformation($id)->data;
        $name       = $user->name;
        $avatar     = $user->avatar;
        $fullName   = urlencode($name. ' ' . $user->lastname);
        $meeting    = LiveMeeting::where('meetingID' , $meetingID)->first();
        $secretKey  = config('global.secret_key_live');
        $checksum   = sha1('join' . 'meetingID='. $meetingID .'&password='. $meeting->moderatorPW .'&fullName='.$fullName . '&redirect=true' . '&joinViaHtml5=true' . '&avatarURL='.$avatar . $secretKey);
        $link       = 'join?meetingID='. $meetingID .'&password='. $meeting->moderatorPW .'&fullName='.$fullName . '&redirect=true' . '&joinViaHtml5=true' . '&avatarURL='.$avatar . '&checksum=' . $checksum;
        $res = array(
            'error' => null,
            'message' => 'your meeting url',
            'body' => array(
                'url' => config('global.live_api').'/'.$link
            )
        );
        return response()->json($res);
    }

    public function join_room_student(Request $request)
    {
        $id         = $request->id;
        $meetingID  = $request->meetingID;
        $Html5      = $request->Html5;
        $resRunning = Live::isMeetingRunning($meetingID);

        if($resRunning['code'] == 200){
            $xml = XmlParser::extract('<api>'.$resRunning['body'].'</api>');
            $met = $xml->parse([
                'returncode' => ['uses' => 'response.returncode']
            ]);
            if($met['returncode'] == 'SUCCESS'){
                $met_1 = $xml->parse([
                    'running' => ['uses' => 'response.running']
                ]);
                if($met_1['running'] == 'false'){
                    $res = array(
                        'error' => 'failed',
                        'message' => 'Room not running',
                        'body' => null
                    );
                }else{
                    $user       = Oauth::userInformation($id)->data;
                    $name       = $user->name;
                    $avatar     = $user->avatar;
                    $fullName   = urlencode($name. ' ' . $user->lastname);
                    $meeting    = LiveMeeting::where('meetingID' , $meetingID)->get()[0];
                    $secretKey  = config('global.secret_key_live');
                    $checksum   = sha1('join' . 'meetingID='. $meetingID .'&password='. $meeting->attendeePW .'&fullName='.$fullName . '&redirect=true' . '&joinViaHtml5=true' . '&avatarURL='.$avatar . $secretKey);
                    $link       = 'join?meetingID='. $meetingID .'&password='. $meeting->attendeePW .'&fullName='.$fullName . '&redirect=true' . '&joinViaHtml5=true' . '&avatarURL='.$avatar . '&checksum=' . $checksum;
                    $res = array(
                        'error' => null,
                        'message' => 'your meeting url',
                        'body' => array(
                            'url' => config('global.live_api').'/'.$link
                        )
                    );
                }
            }else{
                $res = array(
                    'error' => 'failed',
                    'message' => 'Room not found',
                    'body' => null
                );
            }
        }else{
            $res = array(
                'error' => 'failed',
                'message' => 'Room not found',
                'body' => null
            );
        }
        return response()->json($res);
    }

    public function is_meeting_running(Request $request)
    {
        $meetingID  = $request->meetingID;
        $response   = Live::isMeetingRunning($meetingID);
        if($response['code'] == 200){
            $xml = XmlParser::extract('<api>'.$response['body'].'</api>');
            $met = $xml->parse([
                'returncode' => ['uses' => 'response.returncode']
            ]);
            if($met['returncode'] == 'SUCCESS'){
                $met_1 = $xml->parse([
                    'running' => ['uses' => 'response.running']
                ]);
                if($met_1['running'] == 'false'){
                    $res = array(
                        'error' => 'failed',
                        'message' => 'Room not running',
                        'body' => null
                    );
                }else{
                    $res = array(
                        'error' => null,
                        'message' => 'success',
                        'body' => 'Room is running'
                    );
                }
            }else{
                $res = array(
                    'error' => 'failed',
                    'message' => 'Room not found',
                    'body' => null
                );
            }
        }else{
            $res = array(
                'error' => 'failed',
                'message' => 'Room not found',
                'body' => null
            );
        }
        return response()->json($res);
    }

    public function meeting_info(Request $request)
    {
        $meetingID  = $request->meetingID;
        $password  = $request->password;
        $response   = Live::getMeetingInfo($meetingID , $password);
        if($response['code'] == 200){
            $xml = XmlParser::extract('<api>'.$response['body'].'</api>');
            $met = $xml->parse([
                'returncode' => ['uses' => 'response.returncode']
            ]);
            if($met['returncode'] == 'SUCCESS'){
                $met_1 = $xml->parse([
                    'messageKey' => ['uses' => 'response.messageKey']
                ]);
                if($met_1['messageKey'] == 'notFound'){
                    $res = array(
                        'error' => 'failed',
                        'message' => 'Room not found',
                        'body' => null
                    );
                }else{
                    $res = array(
                        'error' => null,
                        'message' => 'success',
                        'body' => 'Room is running'
                    );
                }
            }else{
                $res = array(
                    'error' => 'failed',
                    'message' => 'Room not found',
                    'body' => null
                );
            }
        }else{
            $res = array(
                'error' => 'failed',
                'message' => 'Room not found',
                'body' => null
            );
        }
        return response()->json($res);
    }

    public function getCourseInfo(Request $request)
    {
        $course_key   = $request->course_key;
        $rate = DB::connection('mysql1')->table('rate_course')
            //->select('item1 , item2 , item3 , item4 , description')
            ->where('course' , $course_key)
            ->get();
        $favorite = DB::connection('mysql1')->table('favorite')
            ->where('code' , $course_key)
            ->where('point' , 1)
            ->count();
        $popular = DB::connection('mysql1')->table('popular')
            ->where('code' , $course_key)
            ->where('point' , 1)
            ->count();

        $res = array(
            'error' => null,
            'message' => 'course information',
            'body' => array(
                'rate' => $rate,
                'favorite' => $favorite,
                'popular' => $popular
            )
        );
        return response()->json($res);
    }
}
