<?php

namespace App\Http\Controllers\Api;

use App\Model\ConductorModel;
use App\Model\ParticipantsModel;
use App\Model\TeacherModel;
use App\Traits\Event;
use App\Traits\Oauth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class EventController extends Controller
{
    use Event;

    public function domains($mobile)
    {
        $urls = array();
        $conductor = ConductorModel::where('mobile' , $mobile)->distinct()->get(['base_url']);
        foreach ($conductor as $value){
            $url = str_replace(array('http://' , 'https://' , '/') , '' , $value->base_url);
            array_push($urls , $url);
        }
        $teacher   = DB::connection('mysql1')->table('teacher')
                        ->join('courses' , 'courses.course_key' , '=' , 'teacher.course_key')
                        ->where('teacher.teacher' , $mobile)
                        ->distinct()
                        ->get(['courses.base_url']);
        foreach ($teacher as $value){
            $url = str_replace(array('http://' , 'https://' , '/') , '' , $value->base_url);
            if(array_search($url , $urls) < 0){
                array_push($urls , $url);
            }
        }
        $student   = DB::connection('mysql1')->table('participants')
                        ->join('courses' , 'courses.course_key' , '=' , 'participants.course_key')
                        ->where('participants.mobile' , $mobile)
                        ->distinct()
                        ->get(['courses.base_url']);
        foreach ($student as $value){
            $url = str_replace(array('http://' , 'https://' , '/') , '' , $value->base_url);
            if(array_search($url , $urls) < 0){
                array_push($urls , $url);
            }
        }
        return response()->json(array('domains' => $urls));
    }

    public function get_types_domain(Request $request)
    {
        $request->validate([
            'mobile' => 'required|string',
            'domain' => 'required|string'
        ]);
        $domain = str_replace('.' , '_' , $request->domain);
        $types = array();
        $conductor   = DB::connection('mysql1')->table('conductor')
            ->join('courses' , 'courses.conductor_key' , '=' , 'conductor.conductor_key')
            ->where('conductor.mobile' , $request->mobile)
            ->where('conductor.base_url' , 'like' , '%'.$request->domain.'/%')
            ->distinct()
            ->get(['courses.course_key']);
        foreach ($conductor as $value){
            $type = 'domain_'.$domain.'_course_'.$value->course_key;
            array_push($types , $type);
        }
        $teacher   = DB::connection('mysql1')->table('teacher')
            ->join('courses' , 'courses.course_key' , '=' , 'teacher.course_key')
            ->where('teacher.teacher' , $request->mobile)
            ->where('courses.base_url' , 'like' , '%'.$request->domain.'/%')
            ->distinct()
            ->get(['courses.course_key']);
        foreach ($teacher as $value){
            $type = 'domain_'.$domain.'_course_'.$value->course_key;
            if(array_search($type , $types) < 0){
                array_push($types , $type);
            }
        }
        $student   = DB::connection('mysql1')->table('participants')
            ->join('courses' , 'courses.course_key' , '=' , 'participants.course_key')
            ->where('participants.mobile' , $request->mobile)
            ->where('courses.base_url' , 'like' , '%'.$request->domain.'/%')
            ->distinct()
            ->get(['courses.course_key']);
        foreach ($student as $value){
            $type = 'domain_'.$domain.'_course_'.$value->course_key;
            if(array_search($type , $types) < 0){
                array_push($types , $type);
            }
        }
        return response()->json(array('types' => $types));
    }

    public function list_event(Request $request)
    {
        $request->validate([
            'types' => 'required|string',
            'user_id' => 'required|integer',
            'from' => 'required|string',
            'to' => 'required|string'
            ]);
        $result = Event::listEvent($request->types , $request->user_id , $request->from , $request->to);
        return response()->json($result);
    }

    public function create_event(Request $request)
    {
        $content = $request->getContent();
        $result = Event::createEvent($content);
        return response()->json($result);
    }

    public function update_event(Request $request , $id)
    {
        $content = $request->getContent();
        $result = Event::EditEvent($content , $id);
        return response()->json($result);
    }

    public function delete_event(Request $request)
    {
        $request->validate([
            'user_id' => 'required',
            'event_id' => 'required'
        ]);
        $result = Event::DeleteEvent($request->user_id , $request->event_id);
        return response()->json($result);
    }

    public function details_event($id)
    {
        $result = Event::DetailsEvent($id);
        return response()->json($result);
    }

    public function register_conflict(Request $request)
    {
        $request->validate([
            'mobile' => 'required',
            'current_key' => 'required'
        ]);
        $student  = DB::connection('mysql1')->table('participants')
            ->join('courses', 'courses.course_key' , '=','participants.course_key')
            ->select('courses.base_url' , 'courses.course_key')
            ->where('participants.mobile' , $request->mobile)
            ->get();
        $other_key = array();
        foreach ($student as $course){
            $base_url = str_replace(array('https://' , 'http://' , '/') , '' , $course->base_url);
            $base_url = str_replace('.' , '_' , $base_url);
            $key = 'domain_'.$base_url.'_course_'.$course->course_key;
            array_push($other_key , $key);
        }
        $content = array(
            "current_key" => $request->current_key,
            "other_key" => $other_key
        );
        $content = json_encode($content);
        $result = Event::RegisterConflict($content);
        return response()->json($result);
    }

    public function course_conflict(Request $request)
    {
        $content = $request->getContent();
        $result = Event::CourseConflict($content);
        return response()->json($result);
    }

    public function teacher_conflict(Request $request)
    {
        $content = $request->getContent();
        $result = Event::TeacherConflict($content);
        return response()->json($result);
    }

    public function events_system(Request $request)
    {
        $mobile = $request->mobile;
        $url = array();
        $data['conductor']   = DB::connection('mysql1')->table('conductor')
            ->join('courses', 'courses.conductor_key' , '=','conductor.conductor_key')
            ->join('course_attr', 'course_attr.course_key' , '=','courses.course_key')
            ->select('courses.base_url' , 'courses.course_key' , 'course_attr.title')
            ->orderBy('courses.base_url' , 'asc')
            ->where('conductor.mobile' , $mobile)
            ->where('course_attr.lang' , 'fa')
            ->distinct()->get();
        $data['teacher']   = DB::connection('mysql1')->table('teacher')
            ->join('courses', 'courses.course_key' , '=','teacher.course_key')
            ->join('course_attr', 'course_attr.course_key' , '=','teacher.course_key')
            ->select('courses.base_url' , 'courses.course_key' , 'course_attr.title')
            ->orderBy('courses.base_url' , 'asc')
            ->where('teacher.teacher' , $mobile)
            ->where('course_attr.lang' , 'fa')
            ->distinct()->get();
        $data['student']   = DB::connection('mysql1')->table('participants')
            ->join('courses', 'courses.course_key' , '=','participants.course_key')
            ->join('course_attr', 'course_attr.course_key' , '=','participants.course_key')
            ->select('courses.base_url' , 'courses.course_key' , 'course_attr.title')
            ->orderBy('courses.base_url' , 'asc')
            ->where('participants.mobile' , $mobile)
            ->where('course_attr.lang' , 'fa')
            ->distinct()->get();
        array_push($url , $data);
        return response()->json($url);
    }

    public function get_user_id(Request $request)
    {
        $numbers = explode(',' , $request->mobile);
        $body = array(
            'numbers' => $numbers
        );
        $body = json_encode($body);
        $response = Oauth::get_id_user_by_mobile($body);
        return response()->json($response);
    }
}
