<?php

namespace App\Http\Controllers\Admin;

use App\User;
use Illuminate\Contracts\Pagination\Paginator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Oauth;
use Illuminate\Pagination\LengthAwarePaginator;

class UserController extends Controller
{
    use Oauth;
    public function __construct()
    {

    }

    public function index(Request $request){
        $search = $request->all();
        $users = Oauth::listUser($request);
        $page_title = 'لیست کاربران';

        return view('admin.users.index' , compact('page_title' , 'users','search'));
    }

    public function user($id){

        $user = Oauth::userInformation($id)->data;

        $page_title = 'اطلاعات کاربر';
        return view('admin.users.user' , compact('page_title' , 'user'));
    }

    public function invoices($id, Request $request){
        $queryString = $request->getQueryString();
        $invoices = Oauth::listInvoices($id,$queryString,$request);
        $page_title = 'صورتحسابها';
        return view('admin.users.invoices' , compact('page_title','invoices'));
    }

    public function invoice($id){
        $invoice = Oauth::invoiceInformation($id)->data;
        $pricewithoutRebate = 0;
        foreach ($invoice->products as $product)
        {
            if ($product->product_code!= config('global.SKU_DISCOUNT') && $product->product_code!= config('global.SKU_DISCOUNT_YEKITA') && $product->product_code!= config('global.SKU_DISCOUNT_SMS') && $product->product_code!= config('global.SKU_DISCOUNT_CREDIT'))
                $pricewithoutRebate=$pricewithoutRebate+$product->price;
        }
        $invoice->pricewithoutRebate = $pricewithoutRebate;

        $page_title = 'صورتحساب';
        return view('admin.users.invoice' , compact('page_title','invoice'));
    }

    public function websites(Request $request , $id){
        $search = $request->all();
        $page_title = 'وبسایتها';
        $queryString = $request->getQueryString();
        $licenses = Oauth::listWebsites($id,$queryString,$request);
        return view('admin.users.websites' , compact('page_title','licenses','search'));
    }

    public function website($id){
        $page_title = 'اطلاعات وبسایت';
        return view('admin.users.website' , compact('page_title'));
    }

}
