<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Slider;
use Illuminate\Support\Facades\File;

class SettingController extends Controller
{
    public function __construct()
    {
    }
    public function index(){
        $page_title = 'تنظیمات سایت';
        return view('admin.setting.index' , compact('page_title'));
    }

    public function slider(){
        $page_title = 'تنظیمات اسلایدر';
        $sliders = Slider::all();
        return view('admin.setting.slider.index' , compact('page_title','sliders'));
    }

    public function sliderCreate(){
        $page_title = 'اضافه کردن اسلایدر';
        return view('admin.setting.slider.create' , compact('page_title'));
    }


    public function sliderStore(Request $request){
        $request->validate([
            'title' => 'required',
            'image' => 'required',
            'alt' => 'required',
            'order' => 'required|integer',
        ]);

        $image = $request->image;  // your base64 encoded
        $image = str_replace('data:image/jpeg;base64,', '', $image);
        $image = str_replace(' ', '+', $image);
        $imageName = str_random(10) . '_' . time() . '.' . 'webp';
        \File::put(public_path() . '/images/' . $imageName, base64_decode($image));

        $request->merge([
            'image' => $imageName,
        ]);

        Slider::create($request->except('_token'));

        Session()->flash('message',' اسلایدر با موفقیت ایجاد شد');
        return redirect()->route('slider_setting');
    }
    
    public function sliderEdit($id,Request $request){
        $page_title = 'ویرایش اسلایدر';
        $slider = Slider::findOrFail($id);
        return view('admin.setting.slider.edit' , compact('page_title','slider'));
    }

    public function sliderUpdate($id,Request $request){
        $request->validate([
            'title' => 'required',
            'alt' => 'required',
            'order' => 'required|integer',
        ]);
        
        $slider = Slider::findOrfail($id);

        if($request->image){
            $image_path = public_path("/images/" . $slider->image);
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            $image = $request->image;  // your base64 encoded
            $image = str_replace('data:image/jpeg;base64,', '', $image);
            $image = str_replace(' ', '+', $image);
            $imageName = str_random(10) . '_' . time() . '.' . 'webp';
            \File::put(public_path() . '/images/' . $imageName, base64_decode($image));

            $request->merge([
                'image' => $imageName,
            ]);

            $input = $request->except('_token');

        }else{
            $input = $request->except(['image','_token']);
        }
        

        $slider->update($input);

        Session()->flash('message',' اسلایدر با موفقیت به روزرسانی شد');
        return redirect()->route('slider_setting');
    }

    public function sliderDelete($id){
        $slider = Slider::findOrFail($id);
        $image_path = public_path("/images/" . $slider->image);
        if(File::exists($image_path)) {
            File::delete($image_path);
        }
        $slider->delete();
        Session()->flash('message',' اسلایدر با موفقیت به حذف شد');
        return redirect()->route('slider_setting');
    }
}
