<?php

namespace App\Http\Controllers\Admin;

use GuzzleHttp\Client;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\URL;

class ProfileController extends Controller
{
    public function __construct()
    {

    }
    public function index(){
        $page_title = 'اطلاعات شما';
        return view('admin.profile.index' , compact('page_title'));
    }
    public function getTokenForCustomer(Request $request)
    {
        $client_id = $request->input("client_id");
        $client_secret = $request->input("client_secret");
        $username = $request->input("email");
        $password = $request->input("password");
        $response = $this->_getAccessToken($username,$password, $client_id, $client_secret);
        $guzzleresult = json_decode((string)$response->getBody(), true);

        $result = [];
        $result['token_type'] = $guzzleresult['token_type'];
        $result['expires_in'] = $guzzleresult['expires_in'];
        $result['access_token'] = $guzzleresult['access_token'];
        $result['refresh_token'] = $guzzleresult['refresh_token'];

        return response()->json(['data' => [ 'access_token' => $result]])->setStatusCode(200);
    }
    function _getAccessToken($username,$password, $client_id, $client_secret)
    {
        $http = new Client();
        $response = $http->post(URL::to('/oauth/token'), [
            'form_params' => [
                'grant_type' => 'password',
                'client_id' => $client_id,
                'client_secret' => $client_secret,
                'username' => $username,
                'password' => $password,
                'scope' => '',
            ],
        ]);

        return $response;

    }
}
