<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Product;
use App\Models\Product as ModelsProduct;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'محصولات';
        $products = Product::all();
        return view('admin.shop.product.index' , compact('page_title','products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $page_title = 'اضافه کردن محصول';
        return view('admin.shop.product.create' , compact('page_title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $request->validate([
            'name' => 'required',
            'price' => 'required|integer',
            'type' => 'required',
            'tax' => 'required|integer',
        ]);

        Product::create($request->except('_token'));

        Session()->flash('message',' محصول با موفقیت ایجاد شد');
        return redirect()->route('all_products');
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page_title = 'ویرایش محصول';
        $product = Product::findOrFail($id);
        return view('admin.shop.product.edit' , compact('page_title','product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   
        $request->validate([
            'name' => 'required',
            'price' => 'required|integer',
            'type' => 'required',
            'tax' => 'required|integer',
        ]);

        $request->merge([
            'status' => $request->status ? $request->status : 0,
        ]);

        $product = Product::findOrfail($id);


        $product->update($request->except('_token'));

        Session()->flash('message',' محصول با موفقیت به روزرسانی شد');
        return redirect()->route('all_products');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $product = Product::findOrFail($id);
        $product->delete();
        Session()->flash('message',' محصول با موفقیت به حذف شد');
        return redirect()->route('all_products');
    }
}
