<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Discount;

class DiscountController extends Controller
{
   /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'کد تخفیف';
        $discounts = Discount::all();
        return view('admin.shop.discount.index' , compact('page_title','discounts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $page_title = 'اضافه کردن کد تخفیف';
        return view('admin.shop.discount.create' , compact('page_title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $request->validate([
            'name' => 'required',
            'code' => 'required',
            'percentage' => 'required|integer',
            'expire_at' => 'required|date',
        ]);

        Discount::create($request->except('_token'));

        Session()->flash('message',' کد تخفیف با موفقیت ایجاد شد');
        return redirect()->route('all_discounts');
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page_title = 'ویرایش کد تخفیف';
        $discount = Discount::findOrFail($id);
        return view('admin.shop.discount.edit' , compact('page_title','discount'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'code' => 'required',
            'percentage' => 'required|integer',
            'expire_at' => 'required|date',
        ]);
        
        $discount = Discount::findOrfail($id);


        $discount->update($request->except('_token'));

        Session()->flash('message',' کد تخفیف با موفقیت به روزرسانی شد');
        return redirect()->route('all_discounts');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $discount = Discount::findOrFail($id);
        $discount->delete();
        Session()->flash('message',' کد تخفیف با موفقیت به حذف شد');
        return redirect()->route('all_discounts');
    }
}
