<?php

namespace App\Http\Controllers\Admin;

use App\Model\Course;
use App\Model\CourseGroupModel;
use App\Traits\Customer;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use App\Traits\Date;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;

class CourseController extends Controller
{
    use Date;
    public function __construct()
    {
        Lang::setLocale('fa');
    }

    public function index(Request $request){
        $page_title = 'لیست دوره ها';
        $search = $request->input('search');
        $state  = $request->input('state');
        $courses = DB::connection('mysql1')->table('courses')
            ->join('course_attr','courses.course_key' , '=','course_attr.course_key' )
            ->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' )
            ->select( 'conductor.conductor' , 'courses.id' , 'courses.course_key' , 'courses.state', 'course_attr.title')
            ->where('conductor.lang' , App::getLocale())
            ->where('course_attr.lang' , App::getLocale())
            ->where(function($query){
                $search = @$_GET['search'];
                $query->where('course_attr.title', 'like', '%' . $search . '%')
                    ->orWhere('courses.course_key', 'like', '%' . $search . '%')
                    ->orWhere('courses.base_url', 'like', '%' . $search . '%');
            })
            ->where(function($query){
                if(isset($_GET['state'])){
                    $state = $_GET['state'];
                    if($state != 200){
                        $query->where('courses.state', $state);
                    }
                }
            })
            ->orderBy('courses.id' , 'desc')
            ->paginate(10);
        return view('admin.course.index' , compact('courses' , 'search' , 'state' , 'page_title'));
    }

    public function course($id){
        $course = DB::connection('mysql1')->table('courses')
            ->join('course_attr','courses.course_key' , '=','course_attr.course_key' )
            ->join('conductor','courses.conductor_key' , '=','conductor.conductor_key' )
            ->select( 'conductor.conductor' , 'courses.capacity' , 'courses.group' , 'courses.base_url' , 'courses.feedback'  , 'courses.quorum' , 'courses.date_start' , 'courses.date_end' , 'courses.date_register' , 'courses.date_quiz' , 'courses.id' , 'courses.cost_register' , 'courses.image' , 'courses.course_key' , 'courses.state', 'courses.create_date', 'course_attr.title' , 'course_attr.certificate_title')
            ->where('conductor.lang' , App::getLocale())
            ->where('course_attr.lang' , App::getLocale())
            ->where('courses.id' , $id)
            ->get()[0];
        $course->group = json_decode($course->group);
        $course->create_date = Date::toJalali($course->create_date);
        $course->date_start = Date::toJalali($course->date_start);
        $course->date_end = Date::toJalali($course->date_end);
        $course->date_register = Date::toJalali($course->date_register);
        $course->date_quiz = Date::toJalali($course->date_quiz);
        $page_title = $course->title;
        $course_group = CourseGroupModel::get();
        $parti = DB::connection('mysql1')->table('participants')
            ->where('course_key' , $course->course_key)
            ->get();
        $participants = count($parti);
        return view('admin.course.course' , compact('course' , 'participants' , 'course_group' , 'page_title'));
    }

    public function reject(Request $request , $id){
        DB::connection('mysql1')->table('courses')
            ->where('id', $id)
            ->update(['state' => 3 , 'feedback' => $request->feedback]);
        return Redirect::to('admin/course/'.$id);
    }

    public function accept($id){
        DB::connection('mysql1')->table('courses')
            ->where('id', $id)
            ->update(['state' => 1]);
        return Redirect::to('admin/course/'.$id);
    }

    public function request_list(Request $request)
    {
        $page_title = 'لیست درخواست ها';
        $result = DB::connection('mysql1')->table('request_course')
            ->orderBy('id' , 'desc')
            ->paginate(10);
        return view('admin.course.request' , compact('result' , 'page_title'));
    }

    public function request_show($id)
    {
        $page_title = 'درخواست';
        $result = DB::connection('mysql1')->table('request_course')
            ->orderBy('id' , 'desc')
            ->where('id' , $id)
            ->get()[0];
        return view('admin.course.request_show' , compact('result' , 'page_title'));
    }

    public function newCourseGroup(Request $request , $id)
    {
        $request->validate([
            'group' => 'required|string'
        ]);
        $json_array = json_encode(explode(',' , $request->group));
        $course = Course::find($id);
        $course->group = $json_array;
        $course->save();
        Customer::updateCourseGroup($json_array , $course->base_url , $course->course_key);
        return back();
    }

}
