<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Model\Blog;
use App\Model\BlogTranslate;
use App\Traits\Date;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;
use Validator;
use Illuminate\Support\Str;


class BlogController extends Controller
{
    use Date;

    public function index(Request $request)
    {
        $page_title = 'لیست مطالب';
        $data = Blog::all();
        $blog = array();
        $i = 0;
        foreach ($data as $value) {
            $blog[$i]['id'] = $value->id;
            $blog[$i]['title'] = $value->bTranslate()->locale()->get()[0]->title;
            $blog[$i]['lang'] = $value->bTranslate()->locale()->get()[0]->lang;
            $blog[$i]['date'] = Date::toJalali($value->bTranslate()->locale()->get()[0]->created_at);
            $i++;
        }
        return view('admin.blog.index', compact('blog', 'page_title'));
    }

    public function create()
    {
        $page_title = 'افزودن مطلب جدید';
        return view('admin.blog.create', compact('page_title'));
    }

    public function store(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'image' => [
                'required'
            ],
            'title' => [
                'required'
            ],
            'sub_title' => [
                'required'
            ],
            'keyword' => [
                'required'
            ],
            'meta_description' => [
                'required'
            ],
            'description' => [
                'required'
            ],
            'content_text' => [
                'required'
            ]
        ]);

        if ($validator->fails()) {
            return redirect('admin/blog/create')
                ->withErrors($validator)
                ->withInput();
        }

        $image = $request->image;  // your base64 encoded
        $image = str_replace('data:image/jpeg;base64,', '', $image);
        $image = str_replace(' ', '+', $image);
        $imageName = str_random(10) . '_' . time() . '.' . 'jpeg';
        \File::put(public_path() . '/images/article/' . $imageName, base64_decode($image));

        Image::make(public_path() . '/images/article/' . $imageName)->resize(580, 314)->save(public_path('/images/article/thumbs/580/' . $imageName));
        Image::make(public_path() . '/images/article/' . $imageName)->resize(380, 206)->save(public_path('/images/article/thumbs/380/' . $imageName));
        Image::make(public_path() . '/images/article/' . $imageName)->resize(280, 152)->save(public_path('/images/article/thumbs/280/' . $imageName));
        Image::make(public_path() . '/images/article/' . $imageName)->resize(240, 130)->save(public_path('/images/article/thumbs/240/' . $imageName));

        $res = Blog::create([
            'status' => $request->status
        ]);

        BlogTranslate::create([
            'blog_id' => $res->id,
            'image' => $imageName,
            'title' => $request->title,
            'sub_title' => $request->sub_title,
            'keyword' => $request->keyword,
            'meta_description' => $request->meta_description,
            'description' => $request->description,
            'content' => $request->content_text,
            'lang' => App::getLocale(),
        ]);
        
        return redirect('/admin/blog/' . $res->id . '/' . App::getLocale());
    }


    public function show($id, $lang)
    {
        DB::enableQueryLog();
        $blog_status = Blog::find($id);
        $data = Blog::find($id)->bTranslate->where('lang', $lang);
        $page_title = $data[0]->title;
        return view('admin.blog.show', compact('data', 'id', 'page_title', 'blog_status'));
    }

    public function language($id)
    {
        $page_title = 'افزودن مطلب به زبانهای دیگر';
        $data = Blog::find($id)->bTranslate;
        $languages = array();
        $i = 0;
        foreach ($data as $value) {
            $languages[$i] = $value->lang;
            $i++;
        }
        $config_lang = config('language');
        return view('admin.blog.languge', compact('languages', 'id', 'config_lang', 'page_title'));
    }

    public function create_translate($id, $lang)
    {

        $page_title = 'ویرایش یا افزودن مطلب';
        $data = Blog::find($id)->bTranslate()->where('lang', $lang)->get();
        $count = count($data);
        return view('admin.blog.create_translate', compact('id', 'count', 'data', 'lang', 'page_title'));
    }

    public function store_translate(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'image' => [
                'required'
            ],
            'title' => [
                'required',
                'max:100'
            ],
            'sub_title' => [
                'required'
            ],
            'keyword' => [
                'required',
                'max:70'
            ],
            'description' => [
                'required',
                'max:170'
            ],
            'content_text' => [
                'required'
            ]
        ]);

        if ($validator->fails()) {
            return redirect('admin/blog/create/' . $request->blog_id . '/' . $request->lang)
                ->withErrors($validator)
                ->withInput();
        }

        $image = $request->image;  // your base64 encoded
        $image = str_replace('data:image/jpeg;base64,', '', $image);
        $image = str_replace(' ', '+', $image);
        $imageName = str_random(10) . '_' . time() . '.' . 'jpeg';
        \File::put(public_path() . '/images/article/' . $imageName, base64_decode($image));

        Image::make(public_path() . '/images/article/' . $imageName)->resize(580, 314)->save(public_path('/images/article/thumbs/580/' . $imageName));
        Image::make(public_path() . '/images/article/' . $imageName)->resize(380, 206)->save(public_path('/images/article/thumbs/380/' . $imageName));
        Image::make(public_path() . '/images/article/' . $imageName)->resize(280, 152)->save(public_path('/images/article/thumbs/280/' . $imageName));
        Image::make(public_path() . '/images/article/' . $imageName)->resize(240, 130)->save(public_path('/images/article/thumbs/240/' . $imageName));

        BlogTranslate::create([
            'blog_id' => $request->blog_id,
            'image' => $imageName,
            'title' => $request->title,
            'sub_title' => $request->sub_title,
            'keyword' => $request->keyword,
            'description' => $request->description,
            'content' => $request->content_text,
            'lang' => $request->lang
        ]);

        return redirect('/admin/blog/' . $request['blog_id'] . '/' . $request['lang']);

    }

    public function edit($id, $lang)
    {
        $page_title = 'ویرایش مطلب';
        $data = Blog::find($id)->bTranslate->where('lang', $lang)[0];
        return view('admin.blog.create', compact('data', 'page_title'));
    }

    public function update(Request $request, $id)
    {

        $validator = Validator::make($request->all(), [
            'title' => [
                'required'
            ],
            'sub_title' => [
                'required'
            ],
            'keyword' => [
                'required'
            ],
            'description' => [
                'required'
            ],
            'content_text' => [
                'required'
            ]
        ]);

        if ($validator->fails()) {
            return redirect('admin/blog/create/' . $request->blog_id . '/' . $request->lang)
                ->withErrors($validator)
                ->withInput();
        }

        if (!is_null($request->image)) {
            $image = $request->image;  // your base64 encoded
            $image = str_replace('data:image/jpeg;base64,', '', $image);
            $image = str_replace(' ', '+', $image);
            $imageName = str_random(10) . '_' . time() . '.' . 'jpeg';
            \File::put(public_path() . '/images/article/' . $imageName, base64_decode($image));

            Image::make(public_path() . '/images/article/' . $imageName)->resize(580, 314)->save(public_path('/images/article/thumbs/580/' . $imageName));
            Image::make(public_path() . '/images/article/' . $imageName)->resize(380, 206)->save(public_path('/images/article/thumbs/380/' . $imageName));
            Image::make(public_path() . '/images/article/' . $imageName)->resize(280, 152)->save(public_path('/images/article/thumbs/280/' . $imageName));
            Image::make(public_path() . '/images/article/' . $imageName)->resize(240, 130)->save(public_path('/images/article/thumbs/240/' . $imageName));
        }

        $blog = BlogTranslate::find($id);
        if (!is_null($request->image)) {
            $blog->image = $imageName;
        }
        $blog->title = $request->title;
        $blog->sub_title = $request->sub_title;
        $blog->keyword = $request->keyword;
        $blog->description = $request->description;
        $blog->content = $request->content_text;
        $blog->save();

        return redirect('/admin/blog/' . $blog->blog_id . '/' . $blog->lang);
    }

    public function destroy($id)
    {
        $blog = Blog::find($id);
        $blog->delete();
        return redirect('/admin/blog');
    }

    public function destroy_translate($id)
    {
        $blog = BlogTranslate::find($id);
        $blog->delete();
        return redirect('/admin/blog');
    }

    public function chang_status(Request $request, $id)
    {
        $status = $request->status;
        Blog::where('id', $id)->update(array('status' => $status));
        return redirect()->back();
    }
}
