<?php
/**
 * This file manage e-payment to use in websites.
 * At first following variables should be set to use in web services.
 *
 * @author Mojtaba Rahbari <mrahbari@infotech-co.com | mojtaba.rahbari@gmail.com>
 * @copyright &copy; from 2015 Infotech International Co.
 * @version 1.0.0
 * @date 2016/06/01 18:56:11 PM
 */

/**
 * public key generated by mabna co
 */
$__PUBLIC_KEY = "
-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCETtzC9pZ+dnQ0z0pXL6pNrkn4vGdbLTf3fhH5
MsVYsFIPuuaUSC9EnbTa8G9p1AIKNsjQaBbzfkvgdu5Tz8qEXZfYQV2bnSCtl/87M7Xn0raAmGTr
jSliTdsxMyJHObzAPkamjHemAxHd9VkwXfZOPAh00ueag+buTAkbzL1MlQIDAQAB
-----END PUBLIC KEY-----
";

/**
 * private key generated by mabna co
 */
$__PRIVATE_KEY = "
-----BEGIN PRIVATE KEY-----
" . trim($__PRIVATE_KEY) . "
-----END PRIVATE KEY-----
";

/**
 * proper web service to do payments
 */
$__SOAP = "https://mabna.shaparak.ir/TokenService?wsdl";

/**
 * include Web Services Toolkit for PHP
 */
$CLIENT = new nusoap_client($__SOAP, 'wsdl');

/**
 * show the errors
 */
$ERROR = $CLIENT->getError();
print_r($ERROR);

/**
 * Make a signature temporary
 * Note: each paid has it's own specific signature
 */
$SOURCE = $__AMT . $__CRN . $__MID . $__REFADD . $__TID;

/**
 * get key resource to start based on public key
 */
$KEY_RESOURCE = openssl_get_publickey($__PUBLIC_KEY);
openssl_public_encrypt($__AMT, $CRYPT_TEXT, $KEY_RESOURCE);

/**
 * Amount Crypted
 */
$AMOUNT = base64_encode($CRYPT_TEXT);

/**
 * CRN Crypted
 **/
openssl_public_encrypt($__CRN, $CRYPT_TEXT, $KEY_RESOURCE);
$CRN = base64_encode($CRYPT_TEXT);

/**
 * MID Crypted
 */
openssl_public_encrypt($__MID, $CRYPT_TEXT, $KEY_RESOURCE);
$MID = base64_encode($CRYPT_TEXT);

/**
 * TID Crypted
 */
openssl_public_encrypt($__TID, $CRYPT_TEXT, $KEY_RESOURCE);
$TID = base64_encode($CRYPT_TEXT);

/**
 * Referral addressCrypted
 */
openssl_public_encrypt($__REFADD, $CRYPT_TEXT, $KEY_RESOURCE);
$REFERRAL = base64_encode($CRYPT_TEXT);

/**
 * Sign data and make final signature
 */
$SIGNATURE = '';
$PRIVATE_KEY = openssl_pkey_get_private($__PRIVATE_KEY);
if (!openssl_sign($SOURCE, $SIGNATURE, $PRIVATE_KEY, OPENSSL_ALGO_SHA1)) {
    echo "OPEN SSL SIGN ERROR";
} else {
    //echo base64_encode($SIGNATURE);
}

/**
 * Make proper array of token params
 */
$INPUT_ARRAY = array(
    "Token_param" =>
        array(
            "AMOUNT" => $AMOUNT,
            "CRN" => $CRN,
            "MID" => $MID,
            "REFERALADRESS" => $REFERRAL,
            "SIGNATURE" => base64_encode($SIGNATURE),
            "TID" => $TID,
        )
);
$WS_RESULT = $CLIENT->call("reservation", $INPUT_ARRAY);
$ERROR = $CLIENT->getError();

/**
 * Final signature is created
 */
$SIGNATURE = base64_decode($WS_RESULT["return"]["signature"]);

/**
 * State whether signature is okay or not
 */
$VERIFY_RESULT = openssl_verify($WS_RESULT["return"]["token"], $SIGNATURE, $KEY_RESOURCE);

/**
 * Free the key from memory
 **/
openssl_free_key($KEY_RESOURCE);

/**
 * Redirect to payment page, if everything is ok
 */
if ($VERIFY_RESULT == 1) {
    echo "
        <style>
            .pre-loader{direction:rtl; position:fixed;background:#ecf0f1;width:100%;height:100%;z-index:9999999;display:block}.pre-loader .load-con{margin:20% auto;position:relative;text-align:center;color:#293889;text-shadow:0 1px 2px rgba(0,0,0,.6)}.pre-loader .spinner{margin:20px auto 0;width:70px;text-align:center}.pre-loader .spinner>div{width:18px;height:18px;background-color:#bdc3c7;border-radius:100%;display:inline-block;-webkit-animation:bouncedelay 1.4s infinite ease-in-out;animation:bouncedelay 1.4s infinite ease-in-out;-webkit-animation-fill-mode:both;animation-fill-mode:both}.pre-loader .spinner .bounce1{-webkit-animation-delay:-.32s;animation-delay:-.32s}.pre-loader .spinner .bounce2{-webkit-animation-delay:-.16s;animation-delay:-.16s}@-webkit-keyframes bouncedelay{0%,100%,80%{-webkit-transform:scale(0)}40%{-webkit-transform:scale(1)}}@keyframes bouncedelay{0%,100%,80%{transform:scale(0);-webkit-transform:scale(0)}40%{transform:scale(1);-webkit-transform:scale(1)}}
        </style>
        <div class=\"pre-loader\">
            <div class=\"load-con\">
                <div class=\"spinner\">
                    <div class=\"bounce1\"></div>
                    <div class=\"bounce2\"></div>
                    <div class=\"bounce3\"></div>
                </div>
            </div>
        </div>".
        $__WAITING_FOR_IPG .
        "<form name=\"paymentForm\" method=\"POST\" action=\"https://mabna.shaparak.ir\" style=\"display: none\">
            <p><input type=\"submit\" value=\"GO TO PAYMENT PAGE\" name=\"B1\"></p>
            <input type=\"hidden\" name=\"TOKEN\" value=\"" . $WS_RESULT["return"]["token"] . "\">
        </form>
        <script type=\"text/javascript\" language=\"JavaScript\">
            setTimeout('loadData()', 0);
            function loadData() {
                document.paymentForm.submit();
            }
        </script>";
} elseif ($VERIFY_RESULT == 0) {
    echo $__ERROR_FAILED_REQUEST;
} else {
    echo $__ERROR_CHECKING_SIGNATURE;
}

/**
 * Manually error handling
 * note: if we have a keys problem, token array will be empty($INPUT_ARRAY)
 */
/*print_r($ERROR);
print_r($WS_RESULT);
echo "<HR>Token: " . $WS_RESULT["return"]["token"];
echo "<br><pre>";
print_r($INPUT_ARRAY);
echo "</pre><hr>";*/
/*echo $KEY . "<br>";
echo ":::::SOURCE:::" . $SOURCE . "::::::::<br>";
echo ":::::SIGNATURE::::" . $SIGNATURE . "::::::::<br>";
echo ":::::PRVKEY:::" . $PRIVATE_KEY . "::::::::<br>";
echo "<hr> ";*/