<?php

namespace App\Console\Commands;

use App\Model\Blog;
use App\Model\BlogTranslate;
use App\User;
use http\Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class ImportBlog extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:blog';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $error = "";
        $result = "";
        $blogs = json_decode(File::get(public_path('db/article-yekita.json')));
        foreach ($blogs->RECORDS as $blg) {
            try {
                $blog = new Blog();
                $blg->status = "active";
                $blog->save();
                $blogTranslate = new BlogTranslate();
                $blogTranslate->blog_id = $blog->id;
                $blogTranslate->title = $blg->title;
                $blogTranslate->keyword = $blg->keyword;
                $blogTranslate->sub_title = $blg->sub_title;
                $blogTranslate->description = $blg->sub_title;
                $blogTranslate->content = $blg->text;
                $blogTranslate->lang = 'fa';
                $blogTranslate->save();
            } catch (Exception $ex) {
                $error .= "<br/>" . $blg->title;
            }
        }
        $result = "This Record Is Not Inserted [Blog]:<br/>" . $error;
        return $result;

    }
}
